#ifndef WRTN_OUTPUT_TYPE_H
#define WRTN_OUTPUT_TYPE_H

#include <string>
#include <boost/variant.hpp>
#include <outilex/xml.h>

struct wrtn_output_type{

  std::string label;
  double weight;

  wrtn_output_type() : label(), weight(0.) {}
  wrtn_output_type(const std::string & s, double w):label(s),weight(w){}
  wrtn_output_type(const std::string & s);
  
  bool operator<(const wrtn_output_type & o) const {    
    if(weight != o.weight) return weight < o.weight;
    return label < o.label;
  }

  void write_xml(xmlwriter & writer) const;
  void read_xml(xmlNodePtr node);
  
};

#endif
