#ifndef _WRTN_GRAMMAR_H_
#define _WRTN_GRAMMAR_H_

#include <vector>
#include <string>

#include <boost/filesystem/path.hpp>

#include <outilex/wrtn_pattern.h>

class ling_def;

/**
 * @brief Class wrtn_grammar represents a weighted recursive transition network
 */

class wrtn_grammar {

public:

  typedef wrtn_pattern::input_type input_type;
  typedef wrtn_pattern::output_type output_type;


  wrtn_grammar(ling_def * ldef) : lingdef(ldef), patterns(), pat_map(), axiom(0) {}
  wrtn_grammar(const boost::filesystem::path & path, ling_def * ldef);

  int start() const { return axiom; }
  const std::string & start_name() const { return patterns[axiom].name; }

  int size() const { return patterns.size(); }

  inline int get_pat_idx(const std::string & name) const;

  wrtn_pattern & operator[](int no) { return patterns[no]; }
  const wrtn_pattern & operator[](int no) const { return patterns[no]; }

  int add_pattern(const wrtn_pattern & pattern);
  int add_pattern(const boost::filesystem::path & patternpath, const std::string & name);

  void write(const boost::filesystem::path & path) const;
  void write_xml(xmlwriter & writer) const;

  void read(const boost::filesystem::path & path);
  void read_xml(xmlNode * node);

public:
  ling_def * lingdef;
  std::vector<wrtn_pattern> patterns;
  std::map<std::string, int> pat_map;
  int axiom;
};

bool flatten(wrtn_grammar & gram, int maxdepth);

int wrtn_grammar::get_pat_idx(const std::string & name) const {
  std::map<std::string, int>::const_iterator it = pat_map.find(name);
  if (it == pat_map.end()) { return -1; }
  return it->second;
}


#endif
