#ifndef _OUTILEX_INFOS_EXTRACTION_H
#define _OUTILEX_INFOS_EXTRACTION_H

#include <string>
#include <outilex/xml.h>


class wrtn_chart;
class xmlwriter;

int extract_infos(wrtn_chart & chart, const std::string & axiom, xmlwriter & writer);


struct infos_extractor {

  xmlwriter writer;
  std::string axiom;
  int nbmatch;

  infos_extractor(const boost::filesystem::path & opath, const std::string & axiom_)
    : writer(opath), axiom(axiom_), nbmatch(0) {
    
      writer.set_indent(1);
      writer.start_document();
      writer.start_element("infos");
    }

  ~infos_extractor() {
    writer.end_element(); // infos
    writer.end_document();
  }


  void operator()(wrtn_chart & chart, int res) {
    nbmatch += extract_infos(chart, axiom, writer);
  }
};


#endif
