#ifndef FSA_TRANSDUCTION_H
#define FSA_TRANSDUCTION_H

#include <string>
#include <outilex/text_fsa.h>
#include <outilex/wrtn_chart.h>


int wchart_fsa_transduct(wrtn_chart & chart, const std::string & axiom);

struct wchart_transducer {

  otext_fsa & otext;
  const std::string & axiom;
  int nbmatch;

  wchart_transducer(otext_fsa & out, const std::string & axiom_)
    : otext(out), axiom(axiom_), nbmatch(0) {}

  void operator()(wrtn_chart & chart, int res) {
    nbmatch += wchart_fsa_transduct(chart, axiom);
    otext << chart.fsa;
  }
};

#endif
