#ifndef FSA_DECORATION_H
#define FSA_DECORATION_H

#include <string>
#include <iostream>
#include <boost/progress.hpp>

#include <outilex/wrtn_chart.h>
#include <outilex/text_fsa.h>

/**
 *  * @brief decore_fsa applies a wrtn on a text automaton and inserts new analyses found in it
 *   * @param otext text automaton
 *    * @param axiom main automaton of wrtn
 *     * @param flags flags
 *      */


int decore_fsa(wrtn_chart & chart, const std::string & axiom, int flags = 0);


const int deco_verbose = 1;
const int deco_replace = 2;

/**
 * @brief struct fsa_decorizer allows for applying a wrtn on a text automaton and inserting new analyses on it
 */

struct fsa_decorizer {

  otext_fsa & otext;
  const std::string & axiom;
  int nbmatch;
  int flags;

  fsa_decorizer(otext_fsa & otext_, const std::string & axiom_, int flags_ = 0)
    : otext(otext_), axiom(axiom_), nbmatch(0), flags(flags_) {}
 
  void operator()(wrtn_chart & chart, int res) {
    nbmatch += decore_fsa(chart, axiom, flags);
    otext << chart.fsa;
  }
};


#endif
