#ifndef CONCORDANCES_XML_H
#define CONCORDANCES_XML_H


#include <iostream>
#include <string>

class wrtn_chart;
class xmlwriter;

static const int CONCORD_SHOW_TAGS = 1;     // output morphosyntactic tags
static const int CONCORD_SHOW_TREE = 2;     // output syntactic tree
static const int CONCORD_LONGEST_MATCH = 4; // output only longest matches
static const int CONCORD_SHOW_OUTPUTS = 8;  // output grammar's outputs
static const int CONCORD_SHOW_WEIGHTS = 16; // output weights


int wchart_make_concordances_xml(const wrtn_chart & chart, xmlwriter & writer,
                                 const std::string & axiom, int flags);

struct wchart_xml_concordancer {

  xmlwriter & writer;
  const std::string & axiom;
  int flags;
  int nbmatch;

  wchart_xml_concordancer(xmlwriter & out, const std::string & axiom_, int f)
    : writer(out), axiom(axiom_), flags(f), nbmatch(0) {}

  void operator()(const wrtn_chart & chart, int res) {
    nbmatch += wchart_make_concordances_xml(chart, writer, axiom, flags);
  }
};

#endif
