#include <iostream>
#include <string>
#include <vector>

#include <outilex/lexico_tree.h>

using namespace std;


struct dumper {

  std::ostream & os;

  dumper(ostream & o) : os(o) {}

  void operator()(const vector<char> & v) {
    std::copy(v.begin(), v.end(), std::ostream_iterator<char>(os));
    os << "\n";
  }
};

int main() {

  lexico_tree<> tree;  
  string line;

  while (getline(cin, line)) {
    tree.insert(line);
  }

  dumper D(cout);
  tree.visit(D);
}

