#ifndef OUTILEX_USAGE_H
#define OUTILEX_USAGE_H

#include <iosfwd>
#include <cstdlib>

extern const char * USAGE_DESCRIPTION;

inline void usage(std::ostream & os, int ret) {
  os << USAGE_DESCRIPTION;
  exit(ret);
}

inline void usage() { usage(std::cout, 0); }
inline void bad_args(const std::string & error_msg = "bad arguments") {
  std::cerr << "\nerror: " << error_msg << "\n\n";
  usage(std::cerr, 1);
}

inline void unknown_arg(const std::string & arg) {
  std::cerr << "\nerror: unknown argument '" << arg << "'\n\n";
  usage(std::cerr, 1);
}

inline void arg_needed(const std::string & arg) {
  std::cerr << "\nerror: option '" << arg << "' needs an argument\n\n";
  usage(std::cerr, 1);
}

#endif
