#ifndef _LEXICO_HASH_TABLE_
#define _LEXICO_HASH_TABLE_

#include <iostream>
#include <vector>
#include "lexico_tree.h"


template<class Data, class Key = char>
class lexico_hash_table {

  typedef Key  key_type;
  typedef Data data_type;
 
  typedef lexico_tree<key_type> lexico_tree_t;

  lexico_tree_t tree;
  std::vector<data_type> tab;


  void dump(const typename lexico_tree_t::node & n,
            std::vector<key_type> & v, std::ostream & os) const {
 
    if (n.no != -1) {
      std::copy(v.begin(), v.end(), std::ostream_iterator<key_type>(os, " "));
      os << ": " << tab[n.no] << "\n";
    }

    typename lexico_tree_t::translist::const_iterator it;

    for (it = n.trans.begin(); it != n.trans.end(); ++it) {
      v.push_back((*it).first);
      dump((*it).second, v, os);
      v.pop_back();
    }
  }


public:

  lexico_hash_table() : tree(), tab() {}
  ~lexico_hash_table() {}


  template<typename Iterator>
  int add(Iterator first, Iterator last, const data_type & v) {
 
    typename lexico_tree_t::node * leaf = tree.insert_path(first, last);

    if (leaf->no == -1) {
      leaf->no = tab.size();
      tab.push_back(v);
    } else {
      tab[leaf->no] = v;
    }
    return leaf->no;
  }

  template<typename Container>
  int add(const Container & c, const data_type & v) { return add(c.begin(), c.end(), v); }


  template<typename Iterator>
  int add_if_not_here(Iterator first, Iterator last, const data_type & v) {
  
    typename lexico_tree_t::node * leaf = tree.insert_path(first, last);

    if (leaf->no != -1) { return leaf->no; }

    leaf->no = tab.size();
    tab.push_back(v);
    return leaf->no;
  }

  template<typename Container>
  int add_if_not_here(const Container & c, const data_type & v) {
    return add_if_not_here(c.begin(), c.end(), v);
  }


  template<typename Iterator>
  int lookup_idx(Iterator first, Iterator last) const { return tree.lookup_idx(first, last); }

  template<typename Container>
  int lookup_idx(const Container & c) { return lookup_idx(c.begin(), c.end()); }


  template<typename Iterator>
  bool lookup(Iterator first, Iterator last, data_type & res) {
    int idx = lookup_idx(first, last);
    if (idx == -1) { return false; }
    res = tab[idx];
    return true;
  }

  template<typename Container>
  bool lookup(const Container & c, data_type & res) {
    return lookup(c.begin(), c.end(), res);
  }


  int size() const { return tab.size(); }


  const data_type & operator[] (int idx) const { return tab[idx]; }

  data_type & operator[] (int idx) { return tab[idx]; }

  void dump(std::ostream & os = std::cerr) const {
    std::vector<key_type> v;
    dump(tree.root, v, os);
  }

  void reserve(int size) { tab.reserve(size); }

  void swap(lexico_hash_table & t) { tree.swap(t.tree); tab.swap(t.tab); }

  void clear() { tree.clear(); tab.clear(); }
};



#endif
