#ifndef _ESCAPE_H_
#define _ESCAPE_H_

#include <string>



inline std::string escape(const std::string & text, const char * to_escape) {
  std::string res;
  int size = text.size();
  for (int i = 0; i < size; ++i) {
    if (strchr(to_escape, text[i])) { res += '\\'; }
    res += text[i];
  }
  return res;
}


inline std::string unescape(const std::string & text) {
  std::string res;
  int size = text.size();
  for (int i = 0; i < size; ++i) {
    if (text[i] == '\\') { ++i; }
    res += text[i];
  }
  return res;
}


inline std::string::size_type find_unescaped(const std::string & text, const char * delim,
                                             std::string::size_type pos = 0) {

  int size = text.size();
  for (int i = 0; i < size; ++i) {
    if (strchr(delim, text[i])) { return i; } 
    if (text[i] == '\\') { ++i; }
  }
  return std::string::npos;
}

inline std::string::size_type find_unescaped(const std::string & text, char c,
                                             std::string::size_type pos = 0) {
  char delim[] = { c, 0 };
  return find_unescaped(text, delim, pos);
}


template<typename OutputIterator>
void stringtok_unescaped(const std::string & txt, const char * delim, OutputIterator it) {

  const std::string::size_type size = txt.size();
  std::string::size_type i = 0;

  while (i < size) {
  
    while ((i < size) && strchr(delim, txt[i])) { ++i; }

    if (i == size) { return; }

    std::string item;
    while (i < size) {
      if (strchr(delim, txt[i])) { break; }
      if (txt[i] == '\\') { ++i; }
      item += txt[i];
      ++i;
    }
    *it = item; ++it;
  }
}

#endif
