#include <iostream>
#include <string>
#include <set>
#include <vector>
#include <iterator>

#include <outilex/DELAentry.h>
#include <outilex/stringtok.h>

using namespace std;


struct feature {

  string code;
  mutable set<string> POSs;

  feature(string c) : code(c), POSs() {}

  friend bool operator< (const feature & a, const feature & b) { return (a.code < b.code); }
};

set<string> codes;

/*
set<string> POSs;
set<feature> synts;
set<feature> flexs;
*/

int nbentries;


int main() {
  
  string form, lemma, cat, synt, flex;

  while (getDELAline(cin, form, lemma, cat, synt, flex)) {

    nbentries++;

    codes.insert(cat);

    /* syntactic features */
    {
      vector<string> feats;
      stringtok(synt, "+", back_inserter(feats));

      for (int i = 0; i < feats.size(); i++) {
        codes.insert(cat + "+" + feats[i]);
      }
    }

    /* inflexional */

    codes.insert(cat + flex);

    /*
    for (int i = 1; i < flex.size(); i++) {
    
      if (flex[i] == ':') { ++nbentries; continue; }
 
      codes.insert(cat + ":" + flex[i]);
    }
    */

    if ((nbentries % 10000) == 0) {
      cout << '.' << flush;
      if ((nbentries % 100000) == 0) { cerr << ' ' << flush; }
    }
  }


  cout << "\ndone. " << codes.size() << " codes.\n";


  std::copy(codes.begin(), codes.end(), ostream_iterator<string>(cout, "\n"));
}

