#include <iostream>
#include <sstream>
#include <string>
#include <map>

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/fstream.hpp>


#include <outilex/DELAentry.h>

using namespace std;
namespace fs = boost::filesystem;

typedef map<string, string> rewrite_rules;
typedef map<string, rewrite_rules> POS_rules;

POS_rules rules;

void init_rules(const fs::path & path) {

  fs::ifstream f(path);

  if (! f) {
    cerr << "cannot open " << path.string() << endl;
    exit(1);
  }

  string line;

  while (getline(f, line)) {

    if (line.empty() or line[0] == '#') { continue; }

    string POS;
    istringstream is(line);
    is >> POS;

    cerr << "POS = '" << POS << "' ...\n";

    rewrite_rules & m = rules[POS];

    while (getline(f, line)) {
    
      if (line.empty() or line[0] == '#') { continue; }

      if (line[0] == '.') { break; }

      string in, out;
      istringstream is(line);
      is >> in >> out;
    
      m[in] = out;      
    }
  }

#if 0
  { // nouns & adjectives

    rewrite_rules & m = rules["N"];
    insert(m)
      (":ms:fs:mp:fp", ":")
      (":ms:fs", ":s")
      (":mp:fp", ":p")
      (":ms:mp", ":m")
      (":fs:fp", ":f")
      ;
  }

  { // verbs
    
    rewrite_rules & m = rules["V"];

    insert(m)
      (":I1s:I2s", ":I12s")
      (":P1s:P3s:S1s:S3s:Y2s", ":PS13s:Y2s")
      (":P2s:S2s", ":PS2s")
      (":P3p:S3p", ":PS3p")
      (":P2p:Y2p", "PY2p")
      (":C1s:C2s", ":C12s")
      
  }
#endif
}

char * progname;
void usage() {
  cout << "usage: " << progname << " -r <rules> [-o <out>] <dic>\n";
  exit(1);
}


int main(int argc, char ** argv) {

  fs::path rulepath, delaf, outpath;

  progname = *argv;
  argv++, argc--;

  if (argc == 0) { usage(); }

  while (argc) {

    string arg = *argv;

    if (arg == "-h") {

      usage();
      
    } else if (arg == "-r") {
    
      argv++, argc--;
      if (! argc) { cerr << "-r needs an arg\n"; exit(1); }
      rulepath = fs::path(*argv);
    
    } else if (arg == "-o") {

      argv++, argc--;
      if (! argc) { cerr << "-o needs an arg\n"; exit(1); }
      outpath = fs::path(*argv);

    } else {

      delaf = fs::path(*argv);
    }

    argv++, argc--;
  }


  if (rulepath.empty() || delaf.empty()) {
    cerr << "argument missing\n";
    exit(1);
  }

  if (outpath.empty()) {
    outpath = delaf.branch_path() / (delaf.leaf() + ".new");
  }

  init_rules(rulepath);

  fs::ifstream in(delaf);
  
  if (! in) { cerr << "unable to open " << delaf.string() << "\n"; exit(1); }

  fs::ofstream out(outpath);

  string form, lemma, cat, synt, flex;

  while (getDELAline(in, form, lemma, cat, synt, flex)) {
    string & res = rules[cat][flex];
    if (! res.empty()) {
      flex = res;
    }
    out << form << "," << lemma << "." << cat << synt << flex << "\n";
  }
  
  cout << "done. result in " << outpath.string() << endl;
}

