#include <iostream>
#include <string>
#include <boost/filesystem/path.hpp>
#include <boost/filesystem/convenience.hpp>

#include <outilex/generic_fst.h>
#include <outilex/FST2_to_generic_fst.h>

using namespace std;
using namespace boost;

namespace fs = boost::filesystem;



char * progname;
void usage(ostream & os = cerr, int ret = 1) {
  os << "usage: " << progname << " <fst2>\n";
  exit(ret);
}


int main(int argc, char ** argv) {

  fs::path ipath, opath;

  progname = *argv;
  argv++, argc--;

  if (argc == 0) { usage(cout, 0); }


  while (argc) {
    string arg = *argv;

    if (arg == "-h") {
      usage();
    
    } else {
    
      ipath = fs::path(arg, fs::native);
    }

    argv++, argc--;
  }

  if (ipath.empty()) {
    cerr << "no FST2 file specified\n";
    return 1;
  }

  if (opath.empty()) {
    opath = fs::change_extension(ipath, ".gfst");
  }

  try {

    generic_fst fst;
    FST2_to_generic_fst(ipath, fst);

    fst.write(opath);

  } catch (exception & e) {
    cerr << "fatal exception : " << e.what() << endl;
    return 1;
  }

  return 0;
}

