#include <iostream>
#include <string>

#include <outilex/DELAentry.h>

using namespace std;

bool cutDELAentry(const string & line, string & form, string & lemma, string & cat, string & synt,
                  string & flex) {

  int comma, dot, plus, colon;

  comma = line.find(',');
  dot   = line.find('.', comma);

  if (comma == line.npos || dot == line.npos) {
    cerr <<  "bad DELAF entry: " << line << "\n";
    return false;
  }

  form.assign(line, 0, comma);
  if (dot > comma + 1) {
    lemma.assign(line, comma + 1, dot - (comma + 1));
  } else {
    lemma = form;
  }
  plus  = line.find('+', dot);
  colon = line.find(':', dot);

  if (plus != line.npos) { // syntaxic codes

    cat.assign(line, dot + 1, plus - (dot + 1));

    if (colon != line.npos) { // inflexional codes too

      synt.assign(line, plus, colon - plus);
      flex.assign(line, colon, line.npos);

    } else { // no inflexional code

      synt.assign(line, plus, line.npos);
      flex.clear();
    }

  } else if (colon != line.npos) { // only inflexional features

    cat.assign(line, dot + 1, colon - (dot + 1));
    synt.clear();
    flex.assign(line, colon, line.npos);

  } else { // zero feature

    cat.assign(line, dot + 1, line.npos);
    synt.clear();
    flex.clear();
  }

  return true;
}


bool getDELAline(istream & is, string & form, string & lemma, string & cat, string & synt, string & flex,
                 bool skip_bad_lines) {

  string line;

  while (getline(is, line)) { 

    /* skip comment */

    int pos = line.find('/'); 

    if (pos != line.npos) { line.erase(pos); }

    if (line[line.size() - 1] == '\r') { line.resize(line.size() - 1); }

    if (line.empty()) { continue; }

    if (cutDELAentry(line, form, lemma, cat, synt, flex)) { return true; }
      
    /* bad entry */
    if (! skip_bad_lines) { break; }
  }

  return false; 
}

