#include <iostream>
#include <string>
#include <sstream>
#include <fstream>

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/fstream.hpp>

#include <outilex/stringtok.h>
#include <outilex/DELAcorresp.h>

using namespace std;

namespace fs = boost::filesystem;

static void bad_line(const std::string & line, const std::string & msg = "") {
  throw runtime_error("DELAFcorresp: parsing error with line : " + line + ": " + msg);
}


void DELAcorresp::read(istream & is) {

  clear();

  string line, w, code, poslist, type, name, attr, value, dumb;

  while (getline(is, line)) {

    int sharp = line.find('#');
    if (sharp != line.npos) {
      line.erase(sharp);
    }

    if (line.empty()) { continue; }

    istringstream in(line);

    if (in >> w) {

      try {

        in.exceptions(ios::badbit | ios::failbit);

        if (w == "POS") {

          in >> code >> name;

          POSs[code] = POS_inf(name);

        } else if (w == "synt") {

          in >> code >> poslist >> type >> attr >> dumb >> value;

          feat_type ftype = (type[0] == 'f') ? FORM_FEAT : LEMMA_FEAT;

          vector<string> vec;

          if (poslist == "*") {
            for (map<string, POS_inf>::const_iterator it = POSs.begin(); it != POSs.end(); ++it) {
              vec.push_back(it->first);
            }
          } else {
            stringtok(poslist, ",", back_inserter(vec));
          }

          for (int i = 0; i < vec.size(); ++i) {

            if (POSs.find(vec[i]) == POSs.end()) {
              bad_line(line, "undeclared POS '" + vec[i] + "'");
            }

            POS_inf & inf = POSs[vec[i]];
            inf.add_synt_code(code, feat_def(ftype, attr, value));
          }

        } else if (w == "inflex" || w == "flex") {

          in >> code >> poslist >> type >> attr >> dumb >> value;

          feat_type ftype = (type[0] == 'f') ? FORM_FEAT : LEMMA_FEAT;

          vector<string> vec;
          if (poslist == "*") {
            for (map<string, POS_inf>::const_iterator it = POSs.begin(); it != POSs.end(); ++it) {
              vec.push_back(it->first);
            }
          } else {
            stringtok(poslist, ",", back_inserter(vec));
          }

          for (int i = 0; i < vec.size(); ++i) {

            if (POSs.find(vec[i]) == POSs.end()) {
              bad_line(line, "undeclared POS '" + vec[i] + "'");
            }

            POS_inf & inf = POSs[vec[i]];
            inf.add_flex_code(code[0], feat_def(ftype, attr, value));
          }

        } else if (w == "garbage") {

          in >> code;
          garbage.insert(code);

        } else if (w == "nolose") {

          continue;

        } else {
          bad_line(line, "bad line (" + w + ")");
        }

      } catch (ios::failure & e) { bad_line(line, "I/O error"); }
    }
  }
}


void DELAcorresp::read(const fs::path & fpath) {
  
  fs::ifstream is(fpath);

  if (! is) {
    throw runtime_error("DELA corresp: unable to open " + fpath.string());
  }

  read(is);
}

