#include <boost/lexical_cast.hpp>
#include <outilex/featstruct.h>
#include <outilex/fs_node.h>

using namespace std;
using namespace boost;


bool is_wellformed(const fs_node * N, int * T) {

  vector<const fs_node *> stack;
  stack.push_back(N);

  const fs_node * node;
  int * tag;


  while (! stack.empty()) {

    node = follow(stack.back()); stack.pop_back();
    tag = T + (node - N);

    if (! node) {
      //cerr << "bad fs node == null\n";
      return false; 
    }

    if (*tag) { continue; }
    *tag = 1;


    if (node->type == FS_EXIST || node->type == FS_CONSTR) {
      //   cerr << "bad fs: node type = " << node->type << endl;
      return false;
    }
    
    //if (node->type == FS_NOEXIST) { node->type = FS_UNSET; }
    if (node->type != FS_FS && node->type != FS_SET) { continue; }
  
    // complex node, check attributes
    const fs_node * attr = node + node->next;
    while (attr != node) {
      stack.push_back(attr + attr->offset);
      attr += attr->next;
    }
  }
  
  //cerr << "good featstruct\n";
  return true;
}



bool is_wellformed(const featstruct & fs) {

  if (! fs) { return false; } // a bottom featstruct is not well-formed

  int size = fs.size();
  int tags[size];
  memset(tags, 0, size * sizeof(int));

  //cerr << "\n\ncheck wellformed : fs = " << fs << endl;
  return is_wellformed(fs.get_entry_node(), tags + fs.entry);
}


#if 0
bool is_wellformed(const fs_node * node) {

  node = follow(node);

  if (! node) { return false; }
  
  if (node->offset) { // already checked
    return true;
  }

  node->offset = 1;

  if (node->type != FS_FS) { // fs is an atomic value (well formed)
    return true;
  }


  /* complex node : look if there is a Pred attribute */

  const fs_node * attr1 = node + node->next;
  const fs_node * n2 = find_attr(attr1, "Pred");

  if (n2) { // yes, check that expected args are there

    n2 = find_attr(attr1, "nArgs");
    if (! n2) { // bad featstruct (Pred without nArgs)
      return false;
    }

    n2 = follow(n2 + n2->offset);
  
    if (n2->type != FS_STRING) { return false; }

    int nArgs = lexical_cast<int>(n2->str);

    char attrname[] = { 'N', '0', 0 };

    n2 = attr1;
    for (int i = 0; i < nArgs; ++i) {
 
      attrname[1] = '0' + i; // maximum of 10 args
 
      n2 = find_attr(n2, attrname);
      if (! n2 || (follow(n2 + n2->offset))->type == FS_UNSET) { // argument Ni is missing
        return false;
      }
    }
  }

 
  /* check all sub-featstruct */

  //attr1 = node + node->next;
  while (attr1 != node) {
    if (! is_wellformed(attr1 + attr1->offset)) { return false; }    
    attr1 += attr1->next;
  }
 
  return true;
}



bool is_wellformed(const featstruct & fs) {

  if (! fs) { return false; } // a bottom featstruct is not well-formed

  return is_wellformed(fs.get_entry_node());
}
#endif

