#include <boost/lexical_cast.hpp>

#include <outilex/stringtok.h>
#include <outilex/weighted_constraints.h>

using namespace std;
using namespace boost;


weighted_constraints::weighted_constraints(const string & text) : constraints(), w(0) {
  
  string::size_type slash = text.find_last_of('/');
  
  if (slash != string::npos) {
    w = lexical_cast<double>(text.substr(slash + 1));
  }
  stringtok(text.substr(0, slash), ",+", back_inserter(constraints));
}


void weighted_constraints::write_XML(xmlwriter & writer) const {

  writer.start_element(xml_name());
  writer.write_attribute("weight", lexical_cast<string>(w));

  for (vector<string>::const_iterator c = constraints.begin(); c != constraints.end(); ++c) {
    writer.write_element("c", *c);
  }
  writer.end_element();
}

void weighted_constraints::read_XML(xmlNodePtr node) {

  w = 0;
  
  char * text = xmlGetProp(node, "weight");
  if (text) {
    w = lexical_cast<double>(text);
    xmlFree(text);
  }
 
  node = node->xmlChildrenNode;
  while (node) {
    if (xmlStrcmp(node->name, "c") == 0) {
      text = (char *) xmlNodeGetContent(node);
      constraints.push_back(text);
      xmlFree(text);
    }
    node = node->next;
  }
}

