#include <outilex/uparser_twopass.h>
#include <vector>
#include <outilex/featstruct.h>
#include <outilex/unification.h>

using namespace std;
using namespace details;



void uparser_twopass::travel(const std::string & fstname, cache_fst & cache, int q, vector<syntref> & path,
                             const featstruct & currfs, double w) {

  uchart & chart = *pchart;
  const sentence_fsa & text = chart.fsa;

  if (cache.final(q)) { // find a match

    if (path.empty()) {
    
      cerr << "pattern '" << fstname  << "' recognize epsilon\n";
      
    }  else {

      int from = path[0].qno;

      featstruct fs;
      fs = currfs.clone();

      if (cache.final_outputs(q).empty()) {
      
        chart.add_match(from, syntagm(fstname, cache.state_in_text(q), fs, path, w));

      } else {

        cerr << "final outputs???\n";

        for (cache_fst::outputs_type::iterator it = cache.final_outputs(q).begin();
             it != cache.final_outputs(q).end(); ++it) {

          const output_type & out  = *it;


          if (out.constraints.size()) {

            check_constraints(out.constraints, fs);

            if (fs) {
              chart.add_match(from, syntagm(fstname, cache.state_in_text(q), fs, path, w * out.w));
            }
          } else {
            chart.add_match(from, syntagm(fstname, cache.state_in_text(q), fs, path, w * out.w));
          }
        }
      }
    }
  }

  for (cache_fst::trans_iterator tr = cache.trans_begin(q); tr != cache.trans_end(q); ++tr) {

    path.push_back(syntref(cache[q].state_in_text, tr->in()));


    if (! tr->out().constraints.empty()) { // unification stuffs

      featstruct fs(currfs);
      //fs = currfs.clone();

      if (tr->in() < 0) { // syntagm transition

        const syntagm & synt = chart.get_synt(cache.state_in_text(q), tr->in());

        fs.set(fs_path("$$"), synt.fs);

      } else { // lex transition

        //const lexical_entry & e = text.get_trans(cache.state_in_text(q), tr->in()).in();
        const lexical_mask & m = text.get_trans(cache.state_in_text(q), tr->in()).in();
        fs.set(fs_path("$$"), m);
      }

      check_constraints(tr->out().constraints, fs);

      if (fs) {
        travel(fstname, cache, tr->to(), path, fs, w * tr->out().w);
      }

    } else {
      travel(fstname, cache, tr->to(), path, currfs, w * tr->out().w);
    }
 
    path.pop_back();
  }
}


int uparser_twopass::inter_state(int q1, const usyntagm_pattern & fst, int q2, cache_fst & cache) {

  uchart & chart = *pchart;
  const sentence_fsa & text = chart.fsa;

  int q = cache.find_state(q1, q2);

  if (q != -1) {
    if (cache.color(q) == gray) { throw runtime_error("inter_state: infinite loop"); }
    return q;
  }

  q = cache.add_state(q1, q2);

  cache.color(q) = gray;

  if (fst.final(q2)) {
    cache.final(q) = true;
    cache.useful(q) = true;
    cache.add_final_outputs(q, fst.final_outputs(q2));
  }

#warning "i don't work: epsilon transitions processing is missing"

  for (usyntagm_pattern::const_trans_iterator str = fst.trans_begin(q2);
       str != fst.trans_end(q2); ++str) {
 
    if (str->in().type == input_type::SUBCALL) {

      const string & syntname = boost::get<string>(str->in().v);

      parse(q1, syntname);
 
      uchart::by_name_iterator begin, end;
      chart.find(q1, syntname, begin, end);

      while (begin != end) {

        const syntagm & match = chart.get_synt(q1, begin->second);

        int to = inter_state(match.to, fst, str->to(), cache);

        if (cache.useful(to)) {
          cache.useful(q) = true;
          cache.add_trans(q, -begin->second, str->out(), to);
        }
        ++begin;
      }

    } else {

      const lexical_mask & m = boost::get<lexical_mask>(str->in().v);

      int transno;
      sentence_fsa::const_trans_iterator tr = text.trans_begin(q1), end = text.trans_end(q1);
      for (transno = 0; tr != end; ++tr, ++transno) { 

        const lexical_mask & e = tr->in();

        //if (e.in(m)) {
        if (e.intersect(m)) {
          int to = inter_state(tr->to(), fst, str->to(), cache);
          
          if (cache.useful(to)) {
            cache.useful(q) = true;
            cache.add_trans(q, transno, str->out(), to);
          }
        }
      }
    }
  }
  

  cache.color(q) = black;

  return q;
}




void uparser_twopass::parse(int q1, int syntno) {

  cache_fst & cache = caches[syntno];
  const usyntagm_pattern & fst = gram[syntno];

  int q = inter_state(q1, fst, fst.start(), cache); // first pass

  vector<syntref> path;

  featstruct fs;
  fs.set(fs_path("CAT"), fst.get_name());

  travel(fst.get_name(), cache, q, path, featstruct(), 1);
}


void uparser_twopass::parse(int q1, const string & syntname) {

  uchart & chart = *pchart;

  uchart::by_name_iterator it = chart.find(q1, syntname);
  if (it != chart.synt_by_name_end(q1)) { // already proceed
    return;
  }

  parse(q1, gram.get_syntagm_idx(syntname));
}



/* entry point
 */
void uparser_twopass::parse(uchart & chart, bool surf) {

  pchart = & chart;
  sentence_fsa & fsa = chart.fsa;
  
  if (surf) {
    for (int q = 0; q < fsa.size(); ++q) {
      parse(q, gram.start());
    }
  } else {
    parse(0, gram.start());
  }
}

