#include <map>

#include <boost/lexical_cast.hpp>
#include <boost/dynamic_bitset.hpp>

#include <outilex/uchart.h>
#include <outilex/xml_format_sentence_fsa.h>


using namespace std;
using namespace boost;



int uchart::node_type::add_match(const syntagm & synt) {
  int idx = syntagms.size();
  syntagms.push_back(synt);
  synt_by_name.insert(make_pair(synt.name, idx));
  return idx;
}

void uchart::node_type::find(const std::string & syntname, by_name_iterator & begin, by_name_iterator & end) {
  begin = synt_by_name.lower_bound(syntname);
  end = synt_by_name.upper_bound(syntname);
}

void uchart::node_type::find(const std::string & syntname,
                         const_by_name_iterator & begin, const_by_name_iterator & end) const {

  begin = synt_by_name.lower_bound(syntname);
  end = synt_by_name.upper_bound(syntname);
}




void uchart::init(const sentence_fsa & fsa_) {
  fsa = fsa_;
  clear();
}

void uchart::eat(sentence_fsa & fsa_) {
  fsa.swap(fsa_);
  clear();
}

void uchart::clear() {
  synt_table.clear();
  synt_table.resize(fsa.size());
}





/* add the specified sytagm and all its dependant syntagms to the new synttable
 */

void uchart::keep_it(int q, int syntno, vector<int> * newids, vector<node_type> & newtable) {

  //cerr << "keepit(" << q << ", " << syntno << ")\n";

  if (newids[q][syntno]) { return; } // already here

  //cerr << "this is new\n";

  syntagm & synt = synt_table[q][syntno];
  
  for (synt_path_type::iterator it = synt.path.begin(); it != synt.path.end(); ++it) {
 
    if (it->transno < 0) { // keep dependant syntagm and remap its no
      keep_it(it->qno, - it->transno - 1, newids, newtable);
      it->transno = newids[it->qno][- it->transno - 1];
    }
  }

  int id = newtable[q].add_match(synt);
  newids[q][syntno] = - id - 1;
}


#if 0
void uchart::check_wellformed(const string & syntname) {

  int q;
  dynamic_bitset<> ok[size()];
  vector<int> tokeep[size()];
  vector<node_type> newtable(size());

  for (q = 0; q < size(); ++q) { 
    tokeep[q].resize(synt_table[q].size(), 0);
    ok[q].resize(synt_table[q].size());
  }

  for (int q = 0; q < size(); ++q) {

    node_type & node = synt_table[q];
    
    for (int i = 0; i < node.size(); ++i) {
    
      if (node[i].name == syntname) {
        if (well_formed(q, i, ok)) { keep_it(q, i, to_keep, newtable); }
      } else {
        keep_it(q, i, to_keep, newtable);
      }
    }
  }

  synt_table.swap(newtable);
}
#endif

void uchart::cleanup(const std::string & syntname, int flags) {
  
//  cerr << "\nuchart::cleanup(" <<  syntname << ", " << flags << ")\n";

  int q;
  vector<int> tokeep[size()];
  vector<node_type> newtable(size());

  for (q = 0; q < size(); ++q) { 
    tokeep[q].resize(synt_table[q].size(), 0); 
  }

  bool check_wellformed = flags & CLEAN_WELLFORMED;
  bool longest_match    = flags & CLEAN_LONGESTMATCH;
  bool by_weight        = flags & CLEAN_BESTMATCH;

  for (q = 0; q < size(); ++q) {
 
    // cerr << "q = " << q << "/" << size() << endl;

    node_type & node = synt_table[q];

    dynamic_bitset<> ok(node.size(), true); // by default every thing is ok (well formed)
 
    int minlen = 0;
    double minweight = 0;

    if (check_wellformed) {

      //cerr << "check wellformed\n";

      for (int i = 0; i < node.size(); ++i) {

        //cerr << "synt " << i << "/" << node.size() << endl;
        if (node[i].name == syntname) {
          
          if (is_wellformed(node[i].fs)) {

            //cerr  << "wellformed\n";

            ok[i] = true;

            if (longest_match) {

              //cerr << "pos(to)= " << fsa.pos(node[i].to) << " pos(from)= " << fsa.pos(q) << endl;

              //int len = fsa.pos(node[i].to) - fsa.pos(q);
              int len = node[i].to - q;
 
              if (len > minlen) {
                minlen = len;
                minweight = node[i].w;
              } else if (len == minlen) {
                if (node[i].w > minweight) { minweight = node[i].w; }
              }

            } else if (by_weight) {
              if (node[i].w > minweight) { minweight = node[i].w; }
            }
 
          } else {
            ok.reset(i);
          }
        }
      }

    } else if (longest_match) {
 
      for (int i = 0; i < node.size(); ++i) {

        if (node[i].name == syntname) {

          //int len = fsa.pos(node[i].to) - fsa.pos(q);
          int len = node[i].to - q;

          if (len > minlen) { 
            minlen = len;
            minweight = node[i].w;
          } else if (len == minlen) {
            if (node[i].w > minweight) { minweight = node[i].w; }
          }
        }
      }
 
    } else if (by_weight) {
    
      for (int i = 0; i < node.size(); ++i) {
        if (node[i].name == syntname) {
          if (node[i].w > minweight) { minweight = node[i].w; }
        }
      }
    }

    for (int i = 0; i < node.size(); ++i) {
      if (node[i].name == syntname) {
        if (check_wellformed && ! ok[i]) { continue; }
        //if (longest_match && (fsa.pos(node[i].to) - fsa.pos(q) < minlen)) { continue; }
        if (longest_match && (node[i].to - q < minlen)) { continue; }
        if (by_weight && node[i].w < minweight) { continue; }
        keep_it(q, i, tokeep, newtable);
      }
    }
  }

  synt_table.swap(newtable);
}

