#include <vector>
#include <outilex/topdown_parser.h>
#include <outilex/featstruct.h>
#include <outilex/unification.h>

using namespace std;


void topdown_parser::parse(int q1, const usyntagm_pattern & fst, int q2, 
                     const featstruct & currfs, double w, vector<syntref> & path) {

  //cerr << "parse(" << q1 << ", " << fst.get_name() << ", " << q2 << ")\n";

  uchart & chart = *pchart;
  const sentence_fsa & text = chart.fsa;

  if (fst.final(q2)) { // we find a match !

    // cerr << "find a match for " << fst.get_name() << "!\n";

    if (path.empty()) {

      cerr << "error: pattern '" << fst.get_name() << "' matches the empty word.\n";

    } else {

      /* retrieve the initial state of the matching sequence */
      int from = path[0].qno;

      if (fst.final_outputs(q2).empty()) {

        //cerr << "adding new match res for " << fst.get_name() << '\n' << "fs = " << currfs << "\n\n"; 

        chart.add_match(from, syntagm(fst.get_name(), q1, currfs, path, w));

      } else {

        cerr << "final outputs ???\n";
        for (usyntagm_pattern::outputs_type::iterator it = fst.final_outputs(q2).begin();
             it != fst.final_outputs(q2).end(); ++it) {

          const output_type & out  = *it;

          if (out.constraints.size()) {

            featstruct fs(currfs);
            check_constraints(out.constraints, fs);

            if (fs) {
              chart.add_match(from, syntagm(fst.get_name(), q1, fs, path, w * out.w));
            }

          } else {
            chart.add_match(from, syntagm(fst.get_name(), q1, currfs, path, w * out.w));
          }
        }
      }
    }
  }

  //cerr << "HERE : parse(" << q1 << ", " << fst.get_name() << ", " << q2 << ")\n";


  for (usyntagm_pattern::const_trans_iterator str = fst.trans_begin(q2), end = fst.trans_end(q2);
       str != end; ++str) {

    //cerr << "in loop\n";

    if (str->in().type == input_type::EPSILON) {
 
      //cerr << "EPSILON\n";

      if (! str->out().constraints.empty()) { // unification stuffs

        featstruct fs(currfs);
        check_constraints(str->out().constraints, fs);

        if (fs) {
          parse(q1, fst, str->to(), fs, w * str->out().w, path);
        }

      } else {
        parse(q1, fst, str->to(), currfs, w * str->out().w, path);
      }

    } else if (str->in().type == input_type::SUBCALL) {

      //cerr << "SUBCALL\n";

      string syntname = boost::get<string>(str->in().v);
      parse(q1, syntname);
 
      //cerr << "back to : parse(" << q1 << ", " << fst.get_name() << ", " << q2 << ")\n";

      uchart::by_name_iterator begin, end;
      chart.find(q1, syntname, begin, end);
 
      /* we copy indexes of matches into a vector, because
       * iterator will probalbly be invalidaded in the following
       * calls of parse()
       */
      vector<int> midxs;
      while (begin != end) {
        midxs.push_back(begin->second);
        ++begin;
      }
      //cerr << midxs.size() << " matches for " << syntname << endl;

      while (! midxs.empty()) {

        int idx = midxs.back();
        midxs.pop_back();

        //cerr << "idx = " << idx << endl;

        path.push_back(syntref(q1, -(idx + 1))); // +1 because indexes start with 1 in path

        const syntagm & match = chart.get_synt(q1, idx);

        if (! str->out().constraints.empty()) { // unification stuffs

          //cerr << "unification stuffs...\n";
          //cerr << "currfs = " << currfs << endl;
          //cerr << "syntfs = " << match.fs << endl;

          featstruct fs(currfs);
          fs.set("$$", match.fs);
          //cerr << "check constraints ... fs=" << fs <<"\n";
          check_constraints(str->out().constraints, fs);
          //cerr << "after constraints: fs = " << fs << endl;

          if (fs) {
#warning should probably take into account the weight of the matched syntagm path
            fs.unlink(fs_path(), "$$");
            parse(match.to, fst, str->to(), fs, w * str->out().w, path);
          }
 
        } else {
          parse(match.to, fst, str->to(), currfs, w * str->out().w, path);
        }

        path.pop_back();
      }

    } else {

      //cerr << "LEX\n";

      const lexical_mask & m = boost::get<lexical_mask>(str->in().v);

      int transno;
      sentence_fsa::const_trans_iterator tr = text.trans_begin(q1), end = text.trans_end(q1);
      for (transno = 0; tr != end; ++tr, ++transno) {

        const lexical_mask & e = tr->in();
        //if (e.in(m)) {
        if (e.intersects(m)) {

          // cerr << "lex_entry #" << transno << " = " << tr->in() << " match!\n";

          path.push_back(syntref(q1, transno));
          if (! str->out().constraints.empty()) { // unification stuffs

            featstruct fs(currfs);

            fs.set(fs_path("$$"), e);

            //cerr << "check_contraints\n";
            check_constraints(str->out().constraints, fs);

            if (fs) {
              fs.unlink(fs_path(), "$$");
              parse(tr->to(), fst, str->to(), fs, w * str->out().w, path);
            }

          } else {

            parse(tr->to(), fst, str->to(), currfs, w * str->out().w, path);
          }
          path.pop_back();
        }
      }
    }
  }
  //cerr << "end of parse(" << q1 << ", " << fst.get_name() << ", " << q2 << ")\n";
}




void topdown_parser::parse(int q1, int syntno) {

  if (proceeded[q1].test(syntno)) { // already proceed
    return;
  }

  const usyntagm_pattern & fst = gram[syntno];

  vector<syntref> path;
  featstruct fs;
  fs.set(fs_path("CAT"), fst.get_name());

  parse(q1, fst, fst.start(), fs, 1, path);
  proceeded[q1].set(syntno);
}


void topdown_parser::parse(int q1, const string & syntname) {

  int syntno = gram.get_syntagm_idx(syntname);
  if (syntno == -1) {
    //cerr << "warning: unknow syntagm '" << syntname << "'\n";
    return;
  }

  parse(q1, syntno);
}


/* entry point
 */
void topdown_parser::parse(uchart & chart, bool surf) {

  pchart = & chart;
  sentence_fsa & fsa = chart.fsa;

  proceeded.resize(fsa.size());
  for (int i = 0; i < proceeded.size(); ++i) {
    proceeded[i].resize(gram.size());
    proceeded[i].reset();
  }

  if (surf) {
    for (int q = 0; q < fsa.size(); ++q) {
      parse(q, gram.start());
    }
  } else {
    parse(0, gram.start());
  }
}


