#ifndef _XML_TEXT_UCHART_H_
#define _XML_TEXT_UCHART_H_

#include <boost/filesystem/path.hpp>

#include <outilex/xml.h>
#include <outilex/xmlReader.h>

#include <outilex/text_uchart.h>
#include <outilex/lexic.h>


class uchart;

class xml_itext_uchart : public itext_uchart {

  boost::filesystem::path path;
  xmlreader reader;
  ling_def * lingdef;
  LEXIC lexic;

  int size_;
  int pos;

public:

  xml_itext_uchart(const boost::filesystem::path & path_, ling_def * ldef)
    : path(), reader(), lingdef(ldef), size_(-1), pos(-1) { open(path_); }

  ~xml_itext_uchart() { close(); }

  void open(const boost::filesystem::path & path);
  void close();

  int size() const { return size_; }

  bool ok() const { return reader && pos != -1; }

  bool read_next(uchart & chart);

  void seek(int pos);
  void rewind();
  int tell() const { return pos; }
};

inline xml_itext_uchart & operator>>(xml_itext_uchart & in, uchart & chart) {
  in.read_next(chart); return in;
}

class xml_otext_uchart : public otext_uchart {

  xmlwriter writer;
 
public:
  xml_otext_uchart(const boost::filesystem::path & path, int size = -1, int compression = 0) 
    : writer() { open(path, size, compression); }
  xml_otext_uchart(std::ostream & os, int size = -1) : writer() { open(os, size); }

  ~xml_otext_uchart() { close(); }

  void open(const boost::filesystem::path & path, int size = -1, int compression = 0);
  void open(std::ostream & os, int size = -1);

  void close();

  void write(const uchart & chart);

  void flush() { return writer.flush(); }

  bool ok() const { return writer; }
};


inline xml_otext_uchart & operator<<(xml_otext_uchart & out, const uchart & chart) {
  out.write(chart); return out;
}

#endif
