#ifndef _WEIGHTED_CONSTRAINTS_H_
#define _WEIGHTED_CONSTRAINTS_H_

#include <vector>
#include <string>

#include <outilex/xmlWriter.h>
#include <outilex/xml.h>


struct weighted_constraints {
  std::vector<std::string> constraints;
  double w;

  inline weighted_constraints() : constraints(), w(0) {}

  /* construct from a XML description */
  inline weighted_constraints(xmlNodePtr node) : constraints(), w(0) { read_XML(node); }
  
  /* construct from a text description */
  weighted_constraints(const std::string & text);

  static inline char * xml_name() { return "wconstraints"; }

  void write_XML(xmlwriter & writer) const;
  void read_XML(xmlNodePtr node);
};


inline bool  operator<(const weighted_constraints & a, const weighted_constraints & b) {
  if (a.w != b.w) { return a.w < b.w; }
  return a.constraints < b.constraints;
}

#endif
