#ifndef _UNIFICATION_H_
#define _UNIFICATION_H_

#include <vector>
#include <string>
#include <list>

#include <outilex/featstruct.h>

// unification on atomic values
feat_set unify(const feat_set & a, const feat_set & b);
feat_set unify(const feat_set & a, const std::string & txt);

// unify to string, transforming them to feat_set of ref_attr_type
feat_set unify(const std::string & a, const std::string & b);


bool check_constraints(const std::vector<std::string> & constraints, featstruct & fs);


/*
bool check_constraints(const std::vector<std::string> & constraints, std::list<featstruct> & fs);

bool check_constraints(const std::vector<std::string> & constraints, featstruct & fs,
                       const featstruct & matchval);
bool check_constraints(const std::vector<std::string> & constraints, featstruct & fs,
                       const lexical_entry & matchval);
*/


#if 0
template<typename FsVal>
bool check_constraints(const std::vector<std::string> & constraints, featstruct & fs, const FsVal & matchval) {
  fs.set("$$", matchval);
  if (! check_constraints(constraints, fs)) { return false; }
  fs.unlink(fs_path(), "$$");
  return true;
}
#endif


/* pour earley 2, qui ne marche pas
 * permet de verifier les contraintes d'unification sur un ensemble
 * de featstruct, à revoir
bool check_constraints(const std::vector<std::string> & constraints, std::list<featstruct> & fs,
                       const featstruct & matchval);
bool check_constraints(const std::vector<std::string> & constraints, std::list<featstruct> & fs,
                       const lexical_entry & matchval);
*/

#if 0
template<typename FsVal>
bool check_constraints(const std::vector<std::string> & constraints, std::list<featstruct> & fs,
                       const FsVal & matchval) {

  std::list<featstruct>::iterator it = fs.begin();

  while (it != fs.end()) {
    if (! check_constraints(constraints, *it, matchval)) {
      it = fs.erase(it);
    } else {
      ++it;
    }
  }

  return ! fs.empty();
}
#endif


#endif

