#ifndef _TOPDOWN_PARSER_H_
#define _TOPDOWN_PARSER_H_

#include <vector>
#include <set>
#include <map>

#include <boost/dynamic_bitset.hpp>

#include <outilex/wgb_color.h>
#include <outilex/usyntagm_pattern.h>
#include <outilex/ugrammar.h>
#include <outilex/sentence_fsa.h>

#include <outilex/uchart.h>
#include <outilex/uparser.h>


class topdown_parser : public uparser {

public:

  typedef ugrammar::input_type  input_type;
  typedef ugrammar::output_type output_type;


  topdown_parser(const ugrammar & grm) : gram(grm), pchart(NULL), proceeded() {}
  ~topdown_parser() {}


  void parse(uchart & chart, bool surf = false);


protected:

  void parse(int q1, const usyntagm_pattern & fst, int q2, 
             const featstruct & currfs, double w,
             std::vector<syntref> & path); 


  void parse(int q1, int syntno);
  void parse(int q1, const std::string & syntname);

protected:
  const ugrammar & gram;
  uchart * pchart;

  std::vector<boost::dynamic_bitset<> > proceeded;
};

#endif
