#ifndef _TEXT_UCHART_H_
#define _TEXT_UCHART_H_

#include <boost/filesystem/path.hpp>

class uchart;
class itext_uchart;
class ling_def;

typedef bool (*ichart_guesser_f)(const boost::filesystem::path & path);
typedef itext_uchart * (*ichart_creator_f)(const boost::filesystem::path & path, ling_def * lingdef);

void register_text_chart_reader(ichart_guesser_f guess, ichart_creator_f create);

struct text_chart_reader_registerer {
  text_chart_reader_registerer(ichart_guesser_f guess, ichart_creator_f create) {
    register_text_chart_reader(guess, create);
  }
};


/* return a text chart reader specialised for the recognised format
 */
itext_uchart * new_itext_uchart(const boost::filesystem::path & path, ling_def * lingdef);

class itext_uchart {

public:

  virtual ~itext_uchart();

  virtual int size() const = 0;

  virtual bool ok() const = 0;

  operator const void*() const { return ok() ? this : 0; }
  bool operator!() const { return ! ok(); }

  virtual bool read_next(uchart & chart) = 0;

  virtual void seek(int pos) = 0;
  virtual void rewind() = 0;
  virtual int tell() const = 0;
};

inline itext_uchart & operator>>(itext_uchart & in, uchart & chart) {
  in.read_next(chart); return in;
}


class otext_uchart {

public:

  virtual ~otext_uchart();

  virtual void write(const uchart & chart) = 0;

  virtual bool ok() const = 0;

  operator bool()  const { return ok(); }
  bool operator!() const { return ! ok(); }
};


inline otext_uchart & operator<<(otext_uchart & out, const uchart & chart) {
  out.write(chart); return out;
}

#endif
