#ifndef _FSA_TEXT_UCHART_H_
#define _FSA_TEXT_UCHART_H_

#include <boost/filesystem/path.hpp>
#include <boost/scoped_ptr.hpp>

#include <outilex/text_uchart.h>


/* implement text_uchart from a text_fsa
 */

class itext_fsa;
class uchart;


class fsa_itext_uchart : public itext_uchart {

  boost::scoped_ptr<itext_fsa> itext;


public:

  fsa_itext_uchart(const boost::filesystem::path & path_, ling_def * ldef);

  ~fsa_itext_uchart() {}

  int size() const;

  bool ok() const;

  bool read_next(uchart & chart);

  void seek(int pos);
  void rewind();
  int tell() const;
};

inline fsa_itext_uchart & operator>>(fsa_itext_uchart & in, uchart & chart) {
  in.read_next(chart); return in;
}


#endif
