#ifndef _FSNODE_H_
#define _FSNODE_H_

#include <outilex/featstruct.h>

typedef featstruct::node fs_node;

void clear_tags(const fs_node * n);

fs_node * follow(fs_node * n);
const fs_node * follow(const fs_node * n);


/* return the attr node names attrname, 0 if not found */
const fs_node * find_attr(const fs_node * n, const std::string & attrname);

/* return the value node of the attribute attrname, 0 if not found */
inline const fs_node * find_attr_val(const fs_node * n, const std::string & attrname) {
  n = find_attr(n, attrname);
  if (n) { return follow(n + n->offset); }
  return 0;
}

bool equal(const fs_node * n1, const fs_node * n2, int * tag1, int * tag2);
bool equal2(const fs_node * n1, const fs_node * n2);

#endif

