#ifndef _FEATSTRUCT_H_
#define _FEATSTRUCT_H_

#include <vector>
#include <string>

#include <boost/shared_ptr.hpp>
//#include <boost/variant.hpp>
//#include <boost/iterator/transform_iterator.hpp>

#include <outilex/xml.h>
#include <outilex/feat_set.h>

class ling_def;
//class lexical_entry;
class lexical_mask;

class fs_path {

public:

  fs_path() : path() {}
  fs_path(const std::string & p) : path() { init(p); }

  /* overload constructor to permit implicit conversion from char * */
  fs_path(const char * p) : path() { init(p); }

  typedef std::vector<std::string>::iterator iterator;
  typedef std::vector<std::string>::const_iterator const_iterator;

  iterator begin() { return path.begin(); }
  const_iterator begin() const { return path.begin(); }
  iterator end() { return path.end(); }
  const_iterator end() const { return path.end(); }

  std::string string() const;

  void dump(std::ostream & os) const;
  
protected:
  
  void init(const std::string & p);

  std::vector<std::string> path;
};


inline std::ostream & operator<<(std::ostream & os, const fs_path & path) {
  path.dump(os); return os;
}


class fs_bad_get : public std::runtime_error {

public:
  
  fs_bad_get(const std::string & txt) : std::runtime_error(txt) {}
 
  fs_bad_get(const fs_path & p, const std::string & txt)
    : std::runtime_error(p.string() + ": " + txt) {}

  ~fs_bad_get() throw() {}

};

// differents types de noeuds dans la structure de traits
// ATTENTION : l'ordre est important (utilise dans unify)

// valeur atomique
#define FS_UNSET        (1)  /* n'importe quelle valeur */
#define FS_EXIST   (1 << 1)  /* la valeur doit etre positionnee (a la fin de l'analyse) */
#define FS_NOEXIST (1 << 2)  /* la valeur ne doit pas etre positionnee */

#define FS_CONSTR  (1 << 3)  /* la valeur doit etre positionnee avec la valeur specifiee */
#define FS_STRING  (1 << 4)  /* valeur textuelle */
#define FS_VAL     (1 << 5)  /* valeur d'un trait (synt/sem/flex...) atomique */

// fs complexe
// representee par une liste chainee cyclique
// du noeud FS_FS, par tous les noeud FS_ATTR, retour au noeud FS_FS
// les noeuds ATTR sont tries par ordre alphabetique
#define FS_FS      (1 << 6)
#define FS_ATTR    (1 << 7)

// ensemble de fs 
// liste chainee cyclique (SET -> SETELEM -> SETELEM -> ... -> SET)
#define FS_SET     (1 << 8)
#define FS_SETELEM (1 << 9)

// reference vers un autre noeud
#define FS_REF     (1 << 10)



class featstruct {

public:

  featstruct() : core(), entry(-1) { clear(); }

  /* deep copy */
  featstruct(const featstruct & fs)
    : core(fs.core), entry(fs.entry) {}

  /* core featstruct is shared between the two featstruct
   * to do a deep copy of the featstruct use the clone member function
   */
  //  featstruct(featstruct & fs) : core(fs.core), entry(fs.entry) {}


  /* clear the featstruct, i.e. set it to UNSET */
  void clear();

  int size() const { return core.size(); }

  // boolean overloads
  operator const void*() const { return is_bottom() ? 0 : this; }
  bool operator!() const { return is_bottom(); }

  // set me to the bottom featstruct
  void set_bottom() { core.clear(); entry = -1; }
  bool is_bottom() const { return core.empty(); }


  /* getter */

  bool has_path(const fs_path & path) const;
  int get_type(const fs_path & path) const;


#if 0
  /* core featstruct is shared between the two featstruct
   */
  featstruct get_fs_val(const fs_path & path);
  const featstruct get_fs_val(const fs_path & path) const;

  const feat_set & get_featset_val(const fs_path & path) const;
  const std::string & get_string_val(const fs_path & path) const;
#endif

  /* set a value into the feature structure
   * this is not a monoton operation (erase the previous value
   * if any)
   * warning can change value reached by other path because 
   * of reentrancy.
   * if one wants to just change/set the value reached from
   * the path, one needs to call unlink first
   */
  bool set(const fs_path & path, const featstruct & value);
  bool set(const fs_path & path, const lexical_mask & value);
  bool set(const fs_path & path, const std::string & value);
  bool set(const fs_path & path, const feat_set & featset);
#if 0
  bool set(const fs_path & path, const lexical_entry & value);
#endif
  
  /* flag the value with (no-)existential or value constraint
   * this is a monoton operation
   */
  // the feat should exist
  bool flag_exist(const fs_path & path);
  // the feat should not exist
  bool flag_noexist(const fs_path & path);
  // the feat should exist and have exactly the specified value
  bool flag_constraint(const fs_path & path, const std::string & val);


  /* unlink featname reached from path */
  void unlink(const fs_path & path);
  void unlink(const fs_path & path, const std::string & featname);


  /* unify two paths in the feature structure */

  bool unify(const fs_path & p1, const fs_path & p2);

  /* unify a path in the feature structure with an external value */

  bool unify(const fs_path & p, const featstruct & fs);
  bool unify(const fs_path & p, const std::string & val);
  bool unify(const fs_path & p, const feat_set & featset);


  /* set managment (insertion) */
 
  // insert an external value (create the set if needed)
  bool set_insert(const fs_path & setpath, const std::string & val);
  // insert a feat already in the featstruct (create the set if needed)
  bool set_insert(const fs_path & setpath, const fs_path & elempath);


  /* compress the featstruct
   * i.e. suppress all values which are no more reachable
   * if clean dollar is true suppress all feats whose name begin with a $
   * (used as temporary variables in grammar)
   */
  void compress(bool cleanvar = true);

  void dump(std::ostream & os) const;
  void prettyprint(std::ostream & os) const;

  void read_xml(xmlNodePtr node, ling_def * ldef);
  void write_xml(xmlwriter & writer) const;


public:

#warning todo: use pointer for str and feat

  struct node {

    node() : type(FS_UNSET), str(), feat(), offset(0), next(0) {}

    /* type du noeud : UNSET, FS, FEAT, REF, SET, etc. */
    int type;

    /* valeur du noeud si FS_STRING
     * nom de l'attribut si FS_ATTR
     */
    std::string str;

    /* valeur de l'attribut si FS_FEAT */
    feat_set feat;

    /* FS_REF : offset de la valeur referencee
     * FS_ATTR: offset de la valeur associee
     * SETELEM : offset de la valeur associee l'element courant
     * -----
     *  pour les noeud à valeur atomique (STRING, FEAT, EXIST, etc.)
     *  ou complexe (FS_FS et FS_SET) : la valeur sert de flag pour savoir
     *           si on a deja visite le noeud.
     *  --> d'ou l'attribut mutable.
     */
    mutable int offset;

    /* si FS_ATTR : offset de l'attribut suivant
     * si FS_SET  : offset de l'element suivant
     */
    int next;
  };


  node * get_entry_node();
  const node * get_entry_node() const;

  bool operator==(const featstruct & b) const;

public:
  std::vector<node> core;
  int entry; // entry point

  int follow(int pos) const;
  void link(int ref, int pos);

  int setup_unset();
  int setup(const std::string & txt);
  int setup(const feat_set & fs);
  int setup(const featstruct & fs);
  int setup(const lexical_mask & fs);
#if 0
  int setup(const lexical_entry & fs);
#endif

  int new_node(int type) {
    int res = core.size();
    core.resize(res + 1);
    core[res].type  = type;
    return res;
  }

  // create a new attribute node, and return its position. 
  // its value is undefined (point to nothing)
  int setup_attr(const std::string & attrname, int next);


  // create a new set elem node and return its position
  // its value point to the node at offset
  int setup_elem(int offset, int next);

  // add attribute featname to the linked attribute list,
  // or return the attribute node if it is already in the list.
  int add_attr(int pos, const std::string & attrname);

  // return the position of the attribute 'attrname' in the attribute list
  // or return -1 if this attribute is not present
  int find_attr(int pos, const std::string & attrname) const;

  // return idx of the set node reached by the specified path
  // create it if needed (-1 on error)
  int setup_set(const fs_path & path);

  // add a new element to the set
  void add_elem(int setpos, int elempos);

  // return the node reached by following path
  // create the node(s) if needed
  int setup_path(const fs_path & path);

  bool unify(int a, int b);
  int unify_(int a, int b);

  void dump(int pos, int & count, int * tag, std::ostream & os) const;
  void prettyprint(int a, int & count, int * tag, int indent, std::ostream & os) const;

  int read_xml_rec(xmlNode * n, std::vector<int> & tag, ling_def * ldef);
  void write_xml(xmlwriter & writer, int pos, int & count, int * tag) const;

  int compress(int e, std::vector<node> & ncore, int * tag, bool cleandollar);

  void make_tag(int * tag) const;
  void make_tag(int pos, int * tag) const;

  int follow(const fs_path & path, int pos) const;
  int follow(const fs_path & path) const { return follow(path, entry); }
};




/* miscellianous functions */

featstruct unify(const featstruct & a, const featstruct & b);

bool is_wellformed(const featstruct & fs);


inline std::ostream & operator<<(std::ostream & os, const featstruct & fs) {
  fs.dump(os); return os;
}


// initialization stuffs, to be call before 
// using unification routines with the current ling_def as parameter

void unification_init(ling_def * ldef);

#endif
