#include <iostream>
#include <boost/filesystem/path.hpp>
#include <boost/filesystem/convenience.hpp>

#include <outilex/lingdef.h>
#include <outilex/generic_fst.h>
#include <outilex/usyntagm_pattern.h>

using namespace std;
using namespace boost;

namespace fs = boost::filesystem;


char * progname;
void usage() {
  cout << "usage: " << progname << " -l <lingdef> <fst>\n";
  exit(0);
}


int main(int argc, char ** argv) try {

  fs::path lingdefpath, ipath, opath;

  char * text = getenv("LINGDEF");
  if (text) {
    lingdefpath = fs::path(text, fs::native);
  }

  progname = *argv;
  argv++, argc--;

  if (argc == 0) { usage(); }

  while (argc) {
    
    string arg = *argv;
    
    if (arg == "-l") {

      argv++, argc--;
      if (argc == 0) { cerr << "bad args\n"; exit(1); }
      lingdefpath = fs::path(*argv, fs::native);
    
    } else if (arg == "-h") {
    
      usage();
    
    } else {
      ipath = arg;
    }
    argv++, argc--;
  }

  if (lingdefpath.empty() || ipath.empty()) { cerr << "bad args\n"; exit(1); }

  ling_def * lingdef = new ling_def(lingdefpath);

  opath = fs::change_extension(ipath, ".upat");

  generic_fst gfst(ipath);
  if (gfst.name.empty()) { gfst.name = fs::basename(ipath); }
  usyntagm_pattern(gfst, lingdef).write(opath);

} catch (exception & e) {
  cerr << "fatal exception : " << e.what() << endl;
  exit(1);
}


