#include <utility>
#include <outilex/cache_fst.h>

using namespace std;


namespace details {

int cache_fst::find_state(int q1, int q2) const {
  states_map::const_iterator it = state_ids.find(make_pair(q1, q2));
  if (it == state_ids.end()) { return -1; }
  return it->second;
}


int cache_fst::add_state(int q1, int q2) {

  pair<int,int> id(q1, q2);

  if (state_ids.find(id) != state_ids.end()) {
    return state_ids[id];
  }

  int res = states.size();

  states.resize(res + 1);
  states[res].state_in_text = q1;

  state_ids[id] = res;

  return res;
}

} // namespace details

