#include <iostream>

#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/fstream.hpp>
#include <boost/filesystem/convenience.hpp>
                       
#include <outilex/lingdef.h>
#include <outilex/string_transducer.h>
#include <outilex/fsa-dump_dot.h>


using namespace std;
namespace fs = boost::filesystem;


char * progname;


void usage() {
  cerr << "usage: " <<
    progname << " -l <lingdef> [-o <output> ] <transducer>\n";
  exit(1);
}




int main(int argc, char ** argv) try {

  fs::path ipath, opath, lingdefpath;

  progname = *argv;
  argv++, argc--;

  char * text = getenv("LINGDEF");
  if (text) {
    lingdefpath = fs::path(text, fs::native);
  }

  if (! argc) {
    usage();
  }

  while (argc) {
    
    string arg = *argv;
    
    if (arg == "-l") {
      
      argv++, argc--;
      if (argc == 0) { usage(); }
      lingdefpath = fs::path(*argv);
    
    } else if (arg == "-o") {
      
      argv++, argc--;
      if (argc == 0) { usage(); }
      opath = fs::path(*argv, fs::native);

    } else if (arg == "-h") {
    
      usage();
    
    } else {
      ipath = fs::path(arg);
    }

    argv++, argc--;
  }

  if (ipath.empty() || lingdefpath.empty()) { usage(); }

  if (opath.empty()) {
    opath = fs::change_extension(ipath, ".dot");
  }

  fs::ofstream os(opath);
  if (! os) { cerr << "unable to open "  << opath.string() << '\n'; exit(1); }


  ling_def lingdef(lingdefpath);

  string_transducer T(ipath, & lingdef);

  fst_dump_dot(T, os);

} catch (exception & e) {

  cerr << "fatal error: excepion caught : " << e.what() << endl;
  return 1;
}
