#ifndef _STRING_TRANSDUCER_H_
#define _STRING_TRANSDUCER_H_

#include <outilex/basic_fst.h>
#include <outilex/fst_output_ops.h>

#include <outilex/lexical_mask.h>

class generic_fst;
class ling_def;


class string_transducer : public basic_fst<lexical_mask, std::string> {

public:

  typedef basic_fst<lexical_mask, std::string> fst_type;

  string_transducer(ling_def * ldef = NULL) : fst_type(), lingdef(ldef) {}
  
  string_transducer(const generic_fst & fst, ling_def * ldef);

  string_transducer(const boost::filesystem::path & path, ling_def * ldef);

  void write(const boost::filesystem::path & path) const;

  ling_def * get_lingdef() const { return lingdef; }

  void check_for_final_outputs();

protected:

  ling_def * lingdef;
};

/* pour concatener les sortie pendant la suppresion des
 * epsilon transitions
 */

//typedef std::plus<std::string> string_concatener;

struct string_transducer_output_ops {
  typedef std::string output_type;

  static std::string one() { return std::string(); } 

  static std::string mult(const std::string & a, const std::string & b) {
    return a + b;
  }
};


template<>
struct fst_output_ops<string_transducer> {
  typedef string_transducer_output_ops type;
};

#endif
