#ifndef _DETER_STRING_FST_H_
#define _DETER_STRING_FST_H_

#include <list>

#include <boost/filesystem/path.hpp>

#include <outilex/lingdef.h>
#include <outilex/lexical_mask2.h>
#include <outilex/delayed_output.h>

#include <outilex/string_transducer.h>


class deter_string_fst {

public:

  typedef lexical_mask2 input_type;
  typedef delayed_output output_type;

  typedef std::set<output_type> outputs_type;


  // position dans le fst original : state + delayed output 

  struct position {

    position(int q_, output_type d) : q(q_), delayed(d) {}

    int q;
    output_type delayed;

    bool operator<(const position & b) const {
      if (q != b.q) { return q < b.q; }
      return delayed < b.delayed;
    }
  };

  typedef std::set<position> stateid;



  struct transition {

    int to_;
    input_type in_;
    output_type out_;

    transition() : to_(-1), in_(), out_() {}
    transition(const input_type & in, const output_type & out, int to)
      : to_(to), in_(in), out_(out) {}

    int to() const { return to_; }
    int & to() { return to_; }

    input_type & in() { return in_; }
    const input_type & in() const  { return in_; }

    output_type & out() { return out_; }
    const output_type & out() const { return out_; }

  };


  typedef std::list<transition> transitions;
  typedef transitions::iterator trans_iterator;
  typedef transitions::const_iterator const_trans_iterator;

  static const int FINAL = 1;
  static const int DETER = 2;

  struct state {

    int flags; // FINAL & DETER
    outputs_type final_outputs;
    transitions trans;

    state() : flags(0), final_outputs(), trans() {}
  };


  deter_string_fst(const string_transducer & T)
    : lingdef(0), id2state(), states() { init_fst(T); }

  deter_string_fst(const boost::filesystem::path & path, ling_def * ldef);



  bool final(int q) const { return states[q].flags & FINAL; }

  void set_final(int q, bool val = true) {
    if (val) {
      states[q].flags |= FINAL;
    } else {
      states[q].flags &= ~(FINAL);
    }
  }

  outputs_type & final_outputs(int q) { return states[q].final_outputs; }
  const outputs_type & final_outputs(int q) const { return states[q].final_outputs; }


  const_trans_iterator trans_begin(int q) const { determinize(q); return states[q].trans.begin(); }
  const_trans_iterator trans_end(int q) const { determinize(q); return states[q].trans.end(); }


  void write(const boost::filesystem::path & path) const;

protected:

  typedef std::map<stateid, int> state_map;

  ling_def * lingdef;
  mutable state_map id2state;
  mutable std::vector<state> states;

  void init_fst(const string_transducer & T); 

  int add_state(const stateid & id) const;
  void init_state(int q, const stateid & id) const;

  void determinize(int q) const;
};


#endif
