#!/bin/bash

set -e

DIC=$HOME/delaf/delaf-Mu.u8.idx


if [ $# != 1 -a $# != 2 ]; then
  echo "usage: $0 [-addsentence] <toktext>"
  exit 1
fi

TOKTXT=$1
OPT=""

if [ $1 = "-addsentence" ]; then
  OPT="-addsentence"
  TOKTXT=$2
fi

POSTXT=${TOKTXT%.xml}.pos
STRIPTXT=${POSTXT%.pos}.strip
TAGTXT=${STRIPTXT%.strip}.tagged
FSA=${STRIPTXT%.strip}.fsa

echo "adding pos elem ...."
tok-add-pos -o $POSTXT $OPT $TOKTXT

echo "striping decoration ..."
tok-strip-deco -o $STRIPTXT $POSTXT

echo "tagging text ..."
apply-dic -dic $DIC -icase -o $TAGTXT $STRIPTXT

echo "make text fsa ..."
tagged2fsa -o $FSA $TAGTXT

echo "set size ..."
tfsa-set-size $FSA


