#include <iostream>
#include <string>

#include <boost/lexical_cast.hpp>
#include <boost/filesystem/path.hpp>
#include <boost/filesystem/convenience.hpp>

#include <outilex/xmlReader.h>
#include <outilex/xmlWriter.h>
#include <outilex/xml.h>

using namespace std;
using namespace boost;

namespace fs = boost::filesystem;


namespace {


xmlwriter writer;


void startDocument(void * d) {
  writer.start_document();
}

void endDocument(void * d) {
  writer.end_document();
}


void startElement(void * ctx, const xmlChar * name, const xmlChar ** atts) {


  if (xmlStrcmp(name, "p") == 0) {
    return;
  }
  
  writer.start_element(name);
 
  if (atts != NULL) {
    for (int i = 0; atts[i]; ++i) {
      if (atts[i + 1]) {
        writer.write_attribute(atts[i], atts[i+1]);
        ++i;
      }
    }
  }
}


void endElement(void * ctx, const xmlChar * name) {

  if (xmlStrcmp(name, "p") == 0) {
    return;
  }
  
  writer.end_element();
}


void characters(void * ctx, const xmlChar * ch, int len) {

  string str((const char *) ch, len);

  writer.write_string(str);
}

void cdataBlock(void * ctx, const xmlChar * value, int len) {

  string str((const char *) value, len);
  writer.write_CDATA(str);
}


/*
 * SAX block
 */

xmlSAXHandler mySAXhandler = {
    NULL, /* internalSubset */
    NULL, /* isStandalone */
    NULL, /* hasInternalSubset */
    NULL, /* hasExternalSubset */
    NULL, /* resolveEntity */
    NULL, /* getEntity */
    NULL, /* entityDecl */
    NULL, /* notationDecl */
    NULL, /* attributeDecl */
    NULL, /* elementDecl */
    NULL, /* unparsedEntityDecl */
    NULL, /* setDocumentLocator */
    startDocument, /* startDocument */
    endDocument, /* endDocument */
    startElement, /* startElement */
    endElement, /* endElement */
    NULL, /* reference */
    characters, /* characters */
    NULL, /* ignorableWhitespace */
    NULL, /* processingInstruction */
    NULL, /* comment */
    NULL, /* xmlParserWarning */
    NULL, /* xmlParserError */
    NULL, /* xmlParserError */
    NULL, /* getParameterEntity */
    cdataBlock, /* cdataBlock; */
    NULL, /* externalSubset; */
    1,
    NULL,
    NULL, /* startElementNs */
    NULL, /* endElementNs */
    NULL  /* xmlStructuredErrorFunc */
};

char * progname;

void usage() {
  cout << "usage: " << progname << " [-o <output> ] <tokenized text>\n";
  exit(0);
}

} // anonymous namespace

int main(int argc, char ** argv) {

  progname = *argv;
  fs::path inpath, outpath;

  argv++, argc--;

  if (! argc) { usage(); }


  while (argc) {
    
    string arg = *argv;
 
    if (arg == "-o") {
      
      argv++, argc--;
      if (! argc) { usage(); }
      
      outpath = fs::path(*argv, fs::native);
    
    } else if (arg == "-h") {
    
      usage();
    
    } else {
      inpath = fs::path(arg, fs::native);
    }
    argv++, argc--;
  }
 
  if (inpath.empty()) {
    cerr << "bad args\n";
    exit(1);
  }
 
  if (outpath.empty()) {
    string fname = fs::basename(inpath) + "-strip.xml";
    outpath = inpath.branch_path() / fname;
  }


  writer.open(outpath);
  
  int res = xmlSAXUserParseFile(& mySAXhandler, NULL, inpath.native_file_string().c_str());

  if (res) { cerr << "some error occured\n"; }

  return res;
}

