#include <iostream>
#include <string>

#include <boost/lexical_cast.hpp>
#include <boost/filesystem/path.hpp>
#include <boost/filesystem/convenience.hpp>

#include <outilex/xmlReader.h>
#include <outilex/xmlWriter.h>
#include <outilex/xml.h>


using namespace std;
using namespace boost;

namespace fs = boost::filesystem;

namespace {

xmlwriter writer;
int nbsentence = 0;
int passno = 0;


void startDocument(void * d) {
  if (passno == 1) { return; }
  writer.start_document();
}

void endDocument(void * d) {
  if (passno == 1) { return; }
  writer.end_document();
}


void startElement(void * ctx, const xmlChar * name, const xmlChar ** atts) {

  if (passno == 1) {
    if (xmlStrcmp(name, "sentence") == 0) { nbsentence++; }
    return;
  }

  writer.start_element(name);

  if (atts != NULL) {
    for (int i = 0; atts[i]; ++i) {
      if (atts[i + 1]) {
        writer.write_attribute(atts[i], atts[i+1]);
        ++i;
      }
    }
  }

  if (passno == 2 && xmlStrcmp(name, "text_fsa") == 0) {
    writer.write_attribute("size", lexical_cast<string>(nbsentence));
  }
}


void endElement(void * ctx, const xmlChar * name) {
  if (passno == 1) { return; }
  writer.end_element();
}


void characters(void * ctx, const xmlChar * ch, int len) {
  if (passno == 1) { return; }
  string str((const char *) ch, len);
  writer.write_string(str);
}



/*
 * SAX block
 */

xmlSAXHandler mySAXhandler = {
    NULL, /* internalSubset */
    NULL, /* isStandalone */
    NULL, /* hasInternalSubset */
    NULL, /* hasExternalSubset */
    NULL, /* resolveEntity */
    NULL, /* getEntity */
    NULL, /* entityDecl */
    NULL, /* notationDecl */
    NULL, /* attributeDecl */
    NULL, /* elementDecl */
    NULL, /* unparsedEntityDecl */
    NULL, /* setDocumentLocator */
    startDocument, /* startDocument */
    endDocument, /* endDocument */
    startElement, /* startElement */
    endElement, /* endElement */
    NULL, /* reference */
    characters, /* characters */
    NULL, /* ignorableWhitespace */
    NULL, /* processingInstruction */
    NULL, /* comment */
    NULL, /* xmlParserWarning */
    NULL, /* xmlParserError */
    NULL, /* xmlParserError */
    NULL, /* getParameterEntity */
    NULL, /* cdataBlock; */
    NULL, /* externalSubset; */
    1,
    NULL,
    NULL, /* startElementNs */
    NULL, /* endElementNs */
    NULL  /* xmlStructuredErrorFunc */
};


char * progname;

void usage() {
  cout << "usage: " << progname << " <texfsa>\n";
  exit(0);
}

} // namespace anonymous



int main(int argc, char ** argv) {

  progname = *argv;
  fs::path fsa, bak;

  argv++, argc--;

  if (! argc) { usage(); }


  while (argc) {
    string arg = *argv;
    fsa = fs::path(arg, fs::native);
    argv++, argc--;
  }
 
  if (fsa.empty()) {
    cerr << "bad args\n";
    exit(1);
  }
 
  bak = fsa.branch_path() / (fsa.leaf() + ".bak");

  if (fs::exists(bak)) { fs::remove(bak); }
  fs::copy_file(fsa, bak);

  // firstpass

  nbsentence = 0;
  passno = 1;

  cerr << "1st pass ...\n";

  int res = xmlSAXUserParseFile(& mySAXhandler, NULL, bak.native_file_string().c_str());
  if (res) { cerr << "some error occured\n"; exit(1); }

  cerr << nbsentence << " sentence\n";

  // second pass
  
  writer.open(fsa);
  passno = 2;

  cerr << "2nd pass ...\n";

  res = xmlSAXUserParseFile(& mySAXhandler, NULL, bak.native_file_string().c_str());
  if (res) { cerr << "some error occured\n"; exit(1); }

  return res;
}

