#include <boost/lexical_cast.hpp>

#include <outilex/xml.h>
#include <outilex/xml-names.h>
#include <outilex/xml_inl_format_sentence_fsa.h>
#include <outilex/xml_format_lexmask.h>
#include <outilex/sentence_fsa.h>
#include <outilex/lexic.h>


using namespace std;
using namespace boost;
using namespace xmlnames;

namespace {

void state_read_inl_xml(xmlNode * node, sentence_fsa & fsa, int q,
                        ling_def * lingdef,  mutable_lexic & lexic) {

  char * text = xmlGetConstProp(node, FINAL_ATTR);

  if (text && *text == '1') { fsa.set_final(q); }

  if (text = xmlGetConstProp(node, POS_ATTR)) {
    fsa.set_pos(q, lexical_cast<int>(text));
  }

  if (text = xmlGetConstProp(node, SIZE_ATTR)) {
    fsa.A.trans_reserve(q, lexical_cast<int>(text));
  }

  node = node->children;

  while (node) {

    if (xmlStrcmp(node->name, TRANS_ELEM) == 0) {
    
      int to = lexical_cast<int>(xmlGetConstProp(node, TO_ATTR));
      lexical_mask m;
      m.clear();

      xmlNode * child = node->children;
      while (child) {
        if (xmlStrcmp(child->name, LEXMASK_ELEM) == 0) {
          lexmask_read_xml(child, m, lingdef);
        }
        child = child->next;
      }
      int label = lexic.add(m);

      //cerr << "m = " << m << ", label = " << label << endl;
      fsa.A.add_trans(q, label, to);
    }

    node = node->next;
  }
}



void state_write_inl_xml(xmlwriter & writer, const sentence_fsa & fsa, int q) {

  writer.start_element(STATE_ELEM);

  writer.write_attribute(ID_ATTR, lexical_cast<string>(q));
  writer.write_attribute(POS_ATTR, lexical_cast<string>(fsa.pos(q)));

  if (fsa.final(q)) { writer.write_attribute(FINAL_ATTR, "1"); }

  for (sentence_fsa::const_trans_iterator tr = fsa.trans_begin(q), end = fsa.trans_end(q);
       tr != end; ++tr) {
    writer.start_element(TRANS_ELEM);
    writer.write_attribute(TO_ATTR, lexical_cast<string>(tr->to()));
    lexmask_write_xml(writer, tr->label());
    writer.end_element();
  }
  writer.end_element();
}

} // namespace ""

void sentence_fsa_read_inline_xml(xmlNode * node, sentence_fsa & fsa, ling_def * lingdef) {

  fsa.clear();
  fsa.set_lingdef(lingdef);


  char * text = xmlGetConstProp(node, SIZE_ATTR);
  if (text) {
    fsa.A.reserve(lexical_cast<int>(text));
  }


  mutable_lexic mlexic;

  int qno = 0;
  node = node->children;

  while (node) {

    if (xmlStrcmp(node->name, STATE_ELEM) == 0) {

      fsa.A.resize(qno + 1);
      state_read_inl_xml(node, fsa, qno, lingdef, mlexic);
      ++qno;
    
    } else if (! xmlNodeIsText(node) && xmlStrcmp(node->name, TEXT_ELEM) == 0) {

      text = (char *) xmlNodeGetContent(node);
      fsa.text = text;
      xmlFree(text);
    }
  
    node = node->next;
  }

  fsa.set_lexic(LEXIC(mlexic));
}


void sentence_fsa_write_inline_xml(xmlwriter & writer, const sentence_fsa & fsa) {

  int size = fsa.size();

  writer.start_element(SENTENCE_FSA_ELEM);
  writer.write_attribute(SIZE_ATTR, lexical_cast<string>(size));

  writer.write_element(TEXT_ELEM, fsa.text);

  for (int q = 0; q < size; ++q) {
    state_write_inl_xml(writer, fsa, q);
  }
  writer.end_element();
}

