#include <boost/lexical_cast.hpp>

#include <outilex/xml.h>
#include <outilex/xml-names.h>
#include <outilex/xml_format_lexmask.h>

#include <outilex/lexic.h>

using namespace std;
using namespace boost;
using namespace xmlnames;



void lexic_read_xml(xmlNode * node, LEXIC & lexic, ling_def * ldef) {

  lexic.clear();

  char * text = xmlGetProp(node, SIZE_ATTR);
  if (text) {
    lexic.reserve(lexical_cast<int>(text));
    xmlFree(text);
  }

  node = node->children;
  while (node) {
    if (xmlStrcmp(node->name, LEXMASK_ELEM) == 0) {
      lexical_mask m;
      lexmask_read_xml(node, m, ldef);
      lexic.lex->tab.push_back(m);
    }
    node = node->next;
  }
}


void lexic_write_xml(xmlwriter & writer, const LEXIC & lexic) {
  writer.start_element(LEXIC_ELEM);
  int size = lexic.size();
  writer.write_attribute(SIZE_ATTR, lexical_cast<string>(size));
  for (int i = 0; i < size; ++i) {
    lexmask_write_xml(writer, lexic[i]);
  }
  writer.end_element();
}

