#include <iostream>
#include <string>

#include <boost/filesystem/path.hpp>

#include <outilex/text_format_lexic.h>
#include <outilex/text_format_sentence_fsa.h>
#include <outilex/sentence_fsa.h>

#include <outilex/txt_text_fsa.h>

using namespace std;
using namespace boost;
namespace fs = boost::filesystem;

int LINK_WITH_TXT_TEXT_FSA;

namespace {

// registration stuffs


bool txt_guess(const fs::path & path) {
  fs::ifstream f(path);
  if (! f) { return false; }
  char c;
  f.get(c);
  if (c != '#') { return false; }
  cerr << "TEXT format detected\n";
  return true;
}

itext_fsa * new_txt_itext_fsa(const fs::path & path, ling_def * ldef) {
  return new txt_itext_fsa(path, ldef);
}

otext_fsa * new_txt_otext_fsa(const fs::path & path, int size, int compression = 0) {
  return new txt_otext_fsa(path, size);
}

text_fsa_reader_registerer itext_registerer(txt_guess, new_txt_itext_fsa);

text_fsa_writer_registerer otext_registerer("text", new_txt_otext_fsa);
text_fsa_writer_registerer otxt_registerer("txt", new_txt_otext_fsa);

} // namespace ""


void txt_itext_fsa::open(const fs::path & p) {
  
  close();
  path = p;
  stream.open(path);

  string line;
  getline(stream, line);
  if (line.empty() || line[0] != '#') {
    cerr << "bin_itext::open : bad first line : " << line << "\n";
    throw runtime_error("txt_open: " + p.string() + " parsing error\n");
  }

  getline(stream, line);
  istringstream(line) >> size_;
 
  cerr << "open ok\n";
  pos_ = 0;
}


void txt_itext_fsa::close() {
  if (stream.is_open()) {
    stream.close();
  }
  stream.clear();
  size_ = pos_ = -1;
}


bool txt_itext_fsa::read_next(sentence_fsa & fsa) {

  //  cerr << "read_next\n";

  if (! stream || pos_ == -1) {
    return false;
  }

  string line;
  while (getline(stream, line)) {
  
    if (line == "lexic") {
    
      lexic_read_text(stream, lexic, lingdef);
 
    } else if (line == "fsa") {
    
      sentence_fsa_read_text(stream, fsa, lexic, lingdef);
      return true;

    } else {
      cerr << "txt_fsa::read_next: bad file format";
      throw runtime_error("txt:fsa: read: parse error");
    }
  }

  /* EOF */
 
  //cerr << "EOF\n";

  pos_ = -1;
  return false;
}


void txt_itext_fsa::rewind() { open(path); }

void txt_itext_fsa::seek(int offset) {

  if (! stream) { 
    throw runtime_error("txt_itext_fsa::seek: no stream");
  }

  if (pos_ == -1 || offset < pos_) { rewind(); }

  string line;
  while (pos_ < offset && getline(stream, line)) {
    
    if (line == "lexic") {
    
      lexic_read_text(stream, lexic, lingdef);
    
    } else if (line == "fsa") {
    
      while (getline(stream, line)) {
        if (line == "f") { break; }
      }
      ++pos_;
    }
  }

  if (! stream) {
    pos_ = -1;
    throw runtime_error("txt_text_fsa::seek: EOF");
  }
}




/* otext_fsa */

txt_otext_fsa::txt_otext_fsa(const boost::filesystem::path & path, int size)
  : stream(), lexic() { 

  cerr << "txt_otext_fsa...\n";
  stream.exceptions(std::ios_base::eofbit | std::ios_base::failbit | std::ios_base::badbit);
  cerr << "before open\n";
  open(path, size); 
}

void txt_otext_fsa::open(const fs::path & path, int size) {

  close();

  lexic.clear();
  stream.open(path);


  stream 
    << "#text fsa\n"
    << size << '\n';
}


void txt_otext_fsa::close() {
  if (stream.is_open()) 
    stream.close();
}


void txt_otext_fsa::write(const sentence_fsa & fsa) {

  if (lexic != fsa.lexic) {
    // cerr << "ofsa::write: change lexic!\n";
    lexic = fsa.lexic;
    stream << "lexic\n";
    lexic_write_text(stream, lexic);
    //cerr << "lexic dumped: " << lexic.size()<< " elements.\n";
  }

  stream << "fsa\n";
  sentence_fsa_write_text(stream, fsa);
}

