#include <iostream>

#include <boost/filesystem/path.hpp>
#include <boost/scoped_ptr.hpp>

#include <outilex/lingdef.h>
#include <outilex/sentence_fsa.h>

#include <outilex/text_fsa.h>

using namespace std;
using namespace boost;
namespace fs = boost::filesystem;

char * progname;

void usage() {
  cout << "usage: " << progname << " [-n <no>] <txtfsa>\n";
  exit(0);
}



int main(int argc, char ** argv) try {

  fs::path txtpath, lingdefpath;
  int sentenceno = -1;

  char * bla = getenv("LINGDEF");
  if (bla) {
    lingdefpath = fs::path(bla);
  }

  progname = *argv;
  argv++, argc--;


  if (argc == 0) { usage(); }

  while (argc) {

    string arg = *argv;

    if (arg == "-h") {

      usage();

    } else if (arg == "-l") {

      argv++, argc--;
      if (argc == 0) { cerr << "bad args\n"; exit(1); }
      lingdefpath = fs::path(*argv);

    } else if (arg == "-n") {

      argv++, argc--;
      if (argc == 0) { cerr << "bad args\n"; exit(1); }
      sentenceno = atoi(*argv);

    } else {

      txtpath = fs::path(arg);
    }

    argv++, argc--;
  }


  if (lingdefpath.empty() || txtpath.empty()) {
    cerr << "bad args\n"; exit(1);
  }


  ling_def lingdef(lingdefpath);

  scoped_ptr<itext_fsa> p_text(new_itext_fsa(txtpath, & lingdef));
  itext_fsa & text = *p_text;;

  sentence_fsa fsa;

  if (sentenceno != -1) {

    text.seek(sentenceno);
    text >> fsa;
    cout << fsa.text << '\n';

  } else {

    while (text >> fsa) { cout << fsa.text << '\n'; }
  }

} catch (exception & e) {
  cerr << "fatal error : " << e.what() << endl;
  exit(1);
}

