#include <iostream>

#include <boost/filesystem/path.hpp>
#include <boost/scoped_ptr.hpp>
#include <boost/timer.hpp>
#include <boost/progress.hpp>

#include <outilex/lingdef.h>
#include <outilex/sentence_fsa.h>

#include <outilex/text_fsa.h>


#include <outilex/usage.h>


using namespace std;
using namespace boost;
namespace fs = boost::filesystem;


const char * USAGE_DESCRIPTION =
"usage: tfsa-info <txtfsa>\n";



int main(int argc, char ** argv) try {

  fs::path txtpath, lingdefpath;
  int sentenceno = -1;

  char * bla = getenv("LINGDEF");
  if (bla) {
    lingdefpath = fs::path(bla);
  }

  argv++, argc--;


  if (argc == 0) { usage(); }

  while (argc) {

    string arg = *argv;

    if (arg == "-h") {

      usage();

    } else if (arg == "-l") {

      argv++, argc--;
      if (argc == 0) { arg_needed(arg); }

      lingdefpath = fs::path(*argv);

    } else if (arg == "-n") {

      argv++, argc--;
      if (argc == 0) { arg_needed(arg); }

      sentenceno = atoi(*argv);

    } else {

      txtpath = fs::path(arg);
    }

    argv++, argc--;
  }


  if (lingdefpath.empty() || txtpath.empty()) { bad_args(); }


  ling_def lingdef(lingdefpath);

  scoped_ptr<itext_fsa> p_text(new_itext_fsa(txtpath, & lingdef));
  itext_fsa & text = *p_text;;

  int nbsentence = 0, nbstate = 0, nbtrans = 0;
  progress_display progress(text.size(), cout);

  boost::timer tmr;

  sentence_fsa fsa;

  while (text >> fsa) {
    nbstate += fsa.size();
    for (int q = 0; q < fsa.size(); ++q) {
      nbtrans += fsa.trans_size(q);
    }
    ++nbsentence;
    ++progress;
  }

  cout << txtpath.string() << ".\n"
    << nbsentence << " sentences. " << nbstate << " states. " << nbtrans << " transitions\n"
    << "average of " << ((double) nbstate) / ((double) nbsentence) << " states and "
    << ((double) nbtrans) / ((double) nbsentence) << " transitions per sentence.\n"
    << tmr.elapsed() << " s.\n";

} catch (exception & e) {
  cerr << "fatal error : " << e.what() << endl;
  exit(1);
}

