#include <outilex/tfsa-dump_xgrf.h>
#include <outilex/unitex_grf.h>
#include <outilex/sentence_fsa.h>
#include <boost/lexical_cast.hpp>
#include <string>

#define WIDTH_OF_A_CHAR 10
#define NBRE_BITS_DE_DECALAGE 19

using namespace std;
using namespace boost;
namespace fs = boost::filesystem;

typedef sentence_fsa::intern_fsa_type intern_fsa_type;

struct liste_nombres {
  int n;
  struct liste_nombres* suivant;
};

struct grf_state {
  char* content;
  int pos_X;
  int rang;
  struct liste_nombres* l;
};

std::map <intern_fsa_type::const_trans_iterator, int> trans_num;



int numeroter_etiquettes_sur_octets_forts(const sentence_fsa &fsa,int nombre_etats) {
  int N = 2;
  for (int i = 0 ; i < nombre_etats ; i++) {    
    for (intern_fsa_type::const_trans_iterator tr = fsa.A.trans_begin(i),
         end = fsa.A.trans_end(i);tr != end; ++tr) {
      trans_num[tr] = N;
      N++;
    }
  }
  return N;
}

void explorer_rang_etat(int etat_courant,
                        const sentence_fsa &fsa,
                        int* rang, char* modif, int* RANG) {

  int RANG_COURANT = rang[etat_courant];
  for (intern_fsa_type::const_trans_iterator tr = fsa.A.trans_begin(etat_courant),
       end = fsa.A.trans_end(etat_courant); tr != end; ++tr) {

    if (RANG_COURANT + 1 > rang[tr->to()]) {
      // if we must increase the path length
      rang[tr->to()] = RANG_COURANT + 1;
      if ((RANG_COURANT+1) > (*RANG)) {
        (*RANG) = RANG_COURANT+1;
      }
      modif[tr->to()] = 1;
    }
  }

  // then, we process all the nodes we have modified
  for (intern_fsa_type::const_trans_iterator tr = fsa.A.trans_begin(etat_courant),
       end = fsa.A.trans_end(etat_courant);
       tr != end; ++tr) {
    if (modif[tr->to()] == 1) {
      // if we must increase the path length
      explorer_rang_etat(tr->to(),fsa,rang,modif,RANG);
      modif[tr->to()] = 0;
    }
  }
}



int calculer_rang(const sentence_fsa& fsa, int * rang, int nombre_etats) {

  char modif[3000];
  int RANG = 0;
  for (int i=0; i < nombre_etats; i++) {
    rang[i]=0;
    modif[i]=0;
  }
  explorer_rang_etat(0, fsa, rang, modif, & RANG);
  return RANG;
}


//
// this function computes the width of the box for the tag s in the sentence GRF
// if s is a not a tag, we return its length
// else, the width is the max of length(inflected), length(lemma), length(code)
//

int width_of_tag(int label,const sentence_fsa &fsa) {
  return lexical_cast<string>(fsa.lexic[label]).length();
}


int calculer_largeur_max_pour_chaque_rang(const sentence_fsa &fsa,
                                          int* pos_X,int nombre_etats,int* rang) {
  int i;

  for (i = 0 ; i < nombre_etats ; i++) {
    pos_X[i] = 0;
  }

  // first, we compute the maximum length for this column
  for (i = 0 ; i < nombre_etats ; i++) {
    for (intern_fsa_type::const_trans_iterator tr = fsa.A.trans_begin(i), end = fsa.A.trans_end(i);
         tr != end; ++tr) {      
      //cerr << lexical_cast<string>(fsa.lexic[tr->label()]) << endl;
      int VAL = WIDTH_OF_A_CHAR * (5 + width_of_tag(tr->label(),fsa));
      if (pos_X[rang[i] + 1] < VAL) {
        pos_X[rang[i] + 1] = VAL;
      }
    }
  }
  // then, we compute the position
  int tmp = 100;
  for (i = 0 ; i < nombre_etats ; i++) {
    pos_X[i] = tmp + pos_X[i];
    tmp = pos_X[i];
  }
  return pos_X[nombre_etats-1];
}

struct liste_nombres* new_liste_nombres() {
  struct liste_nombres* l;
  l=(struct liste_nombres*)malloc(sizeof(struct liste_nombres));
  l->suivant=NULL;
  return l;
}

void free_liste_nombres(struct liste_nombres* l) {
  struct liste_nombres* tmp;
  while (l!=NULL) {
    tmp=l;
    l=l->suivant;
    free(tmp);
  }
}


struct liste_nombres* inserer_dans_liste_nombres(int n,struct liste_nombres* l) {
  struct liste_nombres* tmp;
  if (l==NULL) {
    tmp=new_liste_nombres();
    tmp->n=n;
    return tmp;
  }
  if (n==l->n) return l;
  if (n<l->n) {
    tmp=new_liste_nombres();
    tmp->n=n;
    tmp->suivant=l;
    return tmp;
  }
  l->suivant=inserer_dans_liste_nombres(n,l->suivant);
  return l;
}

int are_equivalent_liste_nombres(struct liste_nombres* a,struct liste_nombres* b) {
  if (a == NULL) {
    if (b == NULL) return 1;
    else return 0;
  } else if (b == NULL) {return 0;}
  if (a->n != b->n) return 0;
  return are_equivalent_liste_nombres(a->suivant,b->suivant);
}


struct grf_state* new_grf_state(string content,int pos_X,int rang) {

  struct grf_state* g = (struct grf_state*)malloc(sizeof(struct grf_state));
  //cerr << "WHAT ?"<< content << endl;
  //string temp(content.c_str().length();
  g->content = (char *)malloc((content.length() + 1) * sizeof(char));
  strcpy(g->content,content.c_str());
  //cerr << "WHAT 2?" <<content.c_str()<< " "<< content.length()<<endl;
  g->pos_X = pos_X;
  g->rang = rang;
  g->l = NULL;
  //cerr << "WHAT 3?" << g->content <<endl;
  return g;
}

void free_grf_state(struct grf_state* g) {
  if (g==NULL) return;
  free(g->content);  
  free_liste_nombres(g->l);
  free(g);
}


void remove_grf_state(struct grf_state** tab_grf_state,int a_garder,int a_virer,int *N) {
  // we keep the right most position
  if (tab_grf_state[a_garder]->pos_X < tab_grf_state[a_virer]->pos_X) {
    tab_grf_state[a_garder]->pos_X = tab_grf_state[a_virer]->pos_X;
  }
  free_grf_state(tab_grf_state[a_virer]);
  tab_grf_state[a_virer]=tab_grf_state[(*N)-1];
  tab_grf_state[(*N)-1]=NULL;
  for (int i=0;i<(*N)-1;i++) {
    struct liste_nombres* l=tab_grf_state[i]->l;
    while (l!=NULL) {
      if (l->n==a_virer) {
        l->n=a_garder;
      }
      else if (l->n==(*N)-1) {
        l->n=a_virer;
      }
      l=l->suivant;
    }
  }
  (*N)--;
}



int are_equivalent_grf_states(struct grf_state* a,struct grf_state* b) {
  if (a == NULL) {
    if (b == NULL) return 1;
    else return 0;
  }
  if (a->content != b->content) return 0;
  return are_equivalent_liste_nombres(a->l,b->l);
}


//
// this function takes an array of grf_state and remove duplicate states
// returns 1 if modification occurred, 0 else
//
int actually_remove_duplicate_grf_states(struct grf_state** tab_grf_state,int *N) {
  for (int i = 0 ; i < (*N) ; i++) {
    for (int j = i + 1 ; j < (*N) ; j++) {
      if (are_equivalent_grf_states(tab_grf_state[i],tab_grf_state[j])) {
        remove_grf_state(tab_grf_state,i,j,N);
        return 1;
      }
    }
  }
  return 0;
}


//
// this function takes an array of grf_state and remove duplicate states
//
void remove_duplicates_grf_states(struct grf_state** tab_grf_state,int *N) {
  while (actually_remove_duplicate_grf_states(tab_grf_state,N));
}


void add_transition_to_grf_state(struct grf_state* g,int arr) {
  g->l=inserer_dans_liste_nombres(arr,g->l);
}

int get_numero_de_la_transition(intern_fsa_type::const_trans_iterator &tr){
  return trans_num[tr];
}


void save_grf_states(const fs::path & opath,struct grf_state** tab_grf_state,int N_GRF_STATES,
                     int rang_max,char* font) {
  unitex_grf grf;
  //unichar z[100];
  int position_verticale[rang_max];
  struct liste_nombres* l;
  int j;

  // we counts the number of boxes for each horizontal position
  for (int i = 0 ; i < rang_max ; i++) {
    position_verticale[i] = 0;
  }


  for (int i = 0 ; i < N_GRF_STATES ; i++) {
    //cerr << i <<" "<<tab_grf_state[i]->rang <<endl;
    position_verticale[tab_grf_state[i]->rang]++;
  }
  //write_grf_header(tab_grf_state[1]->pos_X+300,800,N_GRF_STATES,font,f);
  grf.width = tab_grf_state[1]->pos_X + 300;
  grf.height = 800;

  grf.boxes.resize(N_GRF_STATES);
  //initial state
  grf.boxes[0].init(50,100,"<E>");

  l = tab_grf_state[0]->l;
  while(l != NULL) {
    grf.boxes[0].add_transition(l->n);
    l = l->suivant;
  }

  // final state
  grf.boxes[1].init(tab_grf_state[1]->pos_X,100,"");

  // other states
  for (int i = 2 ; i < N_GRF_STATES ; i++) {
    j = 100 - (50 * (tab_grf_state[i]->rang % 2))+ 100 * (--position_verticale[tab_grf_state[i]->rang]);
    //cerr <<position_verticale[tab_grf_state[i]->rang]<< endl; 
    grf.boxes[i].init(tab_grf_state[i]->pos_X,j,lexical_cast<string>(tab_grf_state[i]->content));

    l = tab_grf_state[i]->l;
    while (l != NULL) {
      grf.boxes[i].add_transition(l->n);
      l=l->suivant;
    }  
  }
  grf.write_xml(opath);

}


void convertir_transitions_en_etats(const sentence_fsa & fsa,
                                    int nombre_etats,int* rang,int N,int rang_max,
                                    int width_max,int* pos_X,char* font,const fs::path & opath) {

  int N_GRF_STATES = 2;
  struct grf_state* tab_grf_state[2000];


  for (int i = 0 ; i < 2000 ; i++) {
    tab_grf_state[i] = NULL;
  }

  tab_grf_state[0] = new_grf_state("\"<E>\"",50,0);

  // we process the initial state
  int j;
  for (intern_fsa_type::const_trans_iterator tr = fsa.A.trans_begin(0),
       end = fsa.A.trans_end(0);tr != end; ++tr) {
    j=get_numero_de_la_transition(tr);
    //cerr << j << endl;
    add_transition_to_grf_state(tab_grf_state[0],j);
  }

  // and the final state
  tab_grf_state[1] = new_grf_state("\"\"",(width_max + 100),rang[1]);

  // then, we save all others states
  for (int i = 0 ; i < nombre_etats ; i++) {
    //  cerr << "etat" << i << endl;
    if (fsa.A.final(i)) {
      //u_fprints_char("\\\"",f);
      tab_grf_state[N_GRF_STATES] = new_grf_state("",pos_X[rang[i]],rang[i]);
    }
    else{
      for (intern_fsa_type::const_trans_iterator tr = fsa.A.trans_begin(i), end = fsa.A.trans_end(i);tr != end; ++tr) {         
        //u_fprints(automate->etiquette[get_etiquette_reelle(trans->etiquette)]->contenu,f);
        tab_grf_state[N_GRF_STATES] = new_grf_state(lexical_cast<string>(fsa.lexic[tr->label()]),pos_X[rang[i]],rang[i]);
        //cerr << lexical_cast<string>(fsa.lexic[tr->label()]) << endl;
        if (fsa.A.final(tr->to())) {
          // if we arrive on the final state
          add_transition_to_grf_state(tab_grf_state[N_GRF_STATES],1);
        } else {
          for (intern_fsa_type::const_trans_iterator tr2 = fsa.A.trans_begin(tr->to()), end = fsa.A.trans_end(tr->to());tr2 != end; ++tr2) {
            //cerr << "get" << endl;
            j = get_numero_de_la_transition(tr2);
            //cerr << j << " "<< N_GRF_STATES << endl;
            add_transition_to_grf_state(tab_grf_state[N_GRF_STATES],j);
            //cerr << j << " "<< N_GRF_STATES << endl;
          }
        }
        N_GRF_STATES++;
      }
    }
  }

  // now, we look for duplicate states
  remove_duplicates_grf_states(tab_grf_state,&N_GRF_STATES);
  // and we save the grf
  save_grf_states(opath,tab_grf_state,N_GRF_STATES,rang_max,font);
  //free grf_states
  for (int i = 0 ; i < 2000 ; i++) {
    free_grf_state(tab_grf_state[i]);
  }
}


void tfsa_dump_xgrf(const sentence_fsa &fsa, const fs::path & opath){      

  if (fsa.size() == 0) {
    throw runtime_error("tfsa dump xgrf: text fsa is empty");
  }


  int nombre_etats=fsa.size();
  int rang[fsa.size()];
  int pos_X[fsa.size()];
  int rang_max = calculer_rang(fsa, rang, nombre_etats);
  int width_max=calculer_largeur_max_pour_chaque_rang(fsa,pos_X,nombre_etats,rang);
  int nombre_etats_res=numeroter_etiquettes_sur_octets_forts(fsa,nombre_etats);

  convertir_transitions_en_etats(fsa, nombre_etats, rang, nombre_etats_res,
                                 rang_max, width_max, pos_X, "my font", opath);
}

