#include <iostream>

#include <boost/filesystem/path.hpp>
#include <boost/scoped_ptr.hpp>
#include <boost/timer.hpp>
#include <boost/progress.hpp>

#include <outilex/lingdef.h>
#include <outilex/sentence_fsa.h>

#include <outilex/text_fsa.h>

using namespace std;
using namespace boost;
namespace fs = boost::filesystem;

char * progname;

void usage() {
  cout << "usage: " << progname << " [-l <lingdef>] [-o <out>] [-gz] [-f <oformat>] <txtfsa>\n";
  exit(0);
}



int main(int argc, char ** argv) try {

  fs::path txtpath, opath, lingdefpath;

  string format;
  int compression = 0;

  char * bla = getenv("LINGDEF");
  if (bla) {
    lingdefpath = fs::path(bla);
  }

  progname = *argv;
  argv++, argc--;

  if (argc == 0) { usage(); }

  while (argc) {

    string arg = *argv;

    if (arg == "-h") {

      usage();

    } else if (arg == "-l") {

      argv++, argc--;
      if (argc == 0) { cerr << "bad args\n"; exit(1); }
      lingdefpath = fs::path(*argv);

    } else if (arg == "-f") {

      argv++, argc--;
      if (argc == 0) { cerr << "bad args\n"; exit(1); }
      format = *argv;

    } else if (arg == "-o") {

      argv++, argc--;
      if (argc == 0) { cerr << "bad args\n"; exit(1); }
      opath = fs::path(*argv);

    } else if (arg == "-gz") {

      compression = 6;

    } else {
      txtpath = fs::path(arg);
    }

    argv++, argc--;
  }

  if (lingdefpath.empty() || txtpath.empty()) {
    cerr << "bad args\n"; exit(1);
  }

  if (format.empty()) { format = "bin"; }

  if (opath.empty()) {
    opath = txtpath.branch_path() / (txtpath.leaf() + ".copy");
  }


  ling_def lingdef(lingdefpath);

  scoped_ptr<itext_fsa> p_itext(new_itext_fsa(txtpath, & lingdef));
  itext_fsa & itext = *p_itext;

  int total = itext.size();

  scoped_ptr<otext_fsa> p_otext(new_otext_fsa(opath, format, total, compression));
  otext_fsa & otext = *p_otext;

  cout << "copying " << txtpath.string() << " into " << opath.string() << " (" << format << " format).\n"
    << total << " sentences expected.\n";

  
  sentence_fsa fsa;
  int sentenceno = 0;

  timer tmr;
  progress_display progress(total, cout);

  while (itext >> fsa) { 
    otext << fsa;
    ++sentenceno; ++progress; 
  }

  cout << "done. " << sentenceno << "/" << total << " sentences, " << tmr.elapsed() << "s.\n";

} catch (exception & e) {
  cerr << "fatal error : " << e.what() << endl;
  exit(1);
}

