#include <iostream>

#include <boost/timer.hpp>
#include <boost/progress.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/scoped_ptr.hpp>
#include <boost/filesystem/path.hpp>
#include <boost/filesystem/fstream.hpp>
#include <boost/filesystem/convenience.hpp>


#include <outilex/text_fsa.h>
#include <outilex/bin_text_fsa.h>
#include <outilex/otext_fsa_lexic_buf.h>

#include <outilex/usage.h>


using namespace std;
using namespace boost;

namespace fs = boost::filesystem;

const char * USAGE_DESCRIPTION =
"usage: tfsa-compress [-o <res>][-l <lingdef>][-size <lexsize>] <tfsa>\n";


int main(int argc, char ** argv) {

  fs::path ipath, opath, ldefpath;
  int lexsize = std::numeric_limits<int>::max();


  {
    char * text = getenv("LINGDEF");
    if (text) { ldefpath = fs::path(text); }
  }

  argv++, argc--;
  if (argc == 0) { usage(); }

  while (argc) {
  
    string arg = *argv;

    if (arg[0] == '-') {
    
      if (arg == "-h") {
        
        usage();
      
      } else if (arg == "-l") {
      
        argv++, argc--;
        if (argc == 0) { arg_needed(arg); }

        ldefpath = fs::path(*argv);
      
      } else if (arg == "-lexsize") {
      
        argv++, argc--;
        if (argc == 0) { arg_needed(arg); }

        lexsize = lexical_cast<int>(*argv);
      
      } else if (arg == "-o") {
      
        argv++, argc--;
        if (argc == 0) { arg_needed(arg); }

        opath = fs::path(*argv);

      } else {
      
        unknown_arg(arg);
      }
    
    } else {
      ipath = fs::path(arg); 
    }
    argv++, argc--;
  }


  if (ipath.empty()) { bad_args("missing argument"); }

  if (opath.empty()) {
    opath = ipath.branch_path() / (ipath.leaf() + ".new");
  }

  ling_def ldef(ldefpath);

  scoped_ptr<itext_fsa> p_itext(new_itext_fsa(ipath, & ldef));
  itext_fsa & itext = *p_itext;

  int total = itext.size();

  bin_otext_fsa binotext(opath, total);
  otext_fsa_lexic_buf otext(binotext, lexsize);

  
  timer tmr;
  int nbsentence = 0;
  progress_display progress(total, cout);
  
  sentence_fsa fsa;
  while (itext >> fsa) {
    otext << fsa;
    ++progress, ++nbsentence;
  }

  cout << "done. result in " << opath.string() << ". "
    << nbsentence << "/" << total << " sentences. "
    << tmr.elapsed() << "s.\n";
}


