#include <iostream>
#include <sstream>
#include <outilex/sentence_fsa.h>
#include <outilex/text_format_sentence_fsa.h>

using namespace std;

namespace {

typedef sentence_fsa::intern_fsa_type intern_fsa_type;

void state_read_text(istream & is, sentence_fsa & fsa, int q) {
 
  string line;
  getline(is, line);
 
  istringstream iss(line);

  char c;
  iss >> c;
  if (c == 'f') { fsa.A.set_final(q); }

  int pos, ntrans, label, to;
  iss >> pos >> ntrans;

  fsa.set_pos(q, pos);
  fsa.A.trans_reserve(q, ntrans);
  
  for (int i = 0; i < ntrans; ++i) {
    iss >> label >> to;
    fsa.A.add_trans(q, label, to);
  }
}


void state_write_text(ostream & os, const sentence_fsa & fsa, int q) {

  os 
    << (fsa.final(q) ? 'f' : ':') 
    << ' ' << fsa.pos(q) << ' ' << fsa.A.trans_size(q);

  for (intern_fsa_type::const_trans_iterator tr = fsa.A.trans_begin(q), end = fsa.A.trans_end(q);
       tr != end; ++tr) {
    os << ' ' << tr->label() << ' ' << tr->to();
  }
  os << '\n';
}


} // namespace ""


void sentence_fsa_read_text(istream & is, sentence_fsa & fsa, LEXIC & lexic, ling_def * lingdef) {

  fsa.set_lingdef(lingdef);
  fsa.set_lexic(lexic);

  fsa.A.clear();

  string line;
  int size;

  getline(is, fsa.text);

  getline(is, line);
  istringstream(line) >> size;

  fsa.A.resize(size);
  for (int q = 0; q < size; ++q) {
    state_read_text(is, fsa, q);
  }
  getline(is, line);
  assert(line == "f");
}


void sentence_fsa_write_text(ostream & os, const sentence_fsa & fsa) {

  int size = fsa.size();

  os 
    << fsa.text << '\n'
    << size << '\n';

  for (int q = 0; q < size; ++q) {
    state_write_text(os, fsa, q);
  }
  os << "f\n";
}

