#include <iostream>

#include <outilex/text_format_lexic.h>
#include <outilex/lexic.h>

using namespace std;

void lexmask_write_text(ostream & os, const lexical_mask & m) {
   os << m << '\n';
}

void lexmask_read_text(istream & is, lexical_mask & m, ling_def * lingdef) {
  string line;
  getline(is, line);
  m.read_text(line, lingdef);
}

void lexic_write_text(ostream & os, const LEXIC & lexic) {

  int size = lexic.size();

  os << size << '\n';

  for (int i = 0; i < size; ++i) {
    lexmask_write_text(os, lexic[i]);
  }
  os << "f\n";
}

void lexic_read_text(istream & is, LEXIC & lexic, ling_def * lingdef) {

  string line;
  getline(is, line);

  lexic.clear(); // we change lexic

  int size;
  istringstream(line) >> size;
  
  lexic.resize(size);
  
  for (int i =  0; i < size; ++i) {
    lexmask_read_text(is, lexic.lex->tab[i], lingdef);
  }
  getline(is, line);
  assert(line == "f");
}

