#include <outilex/sentence_fsa.h>

#include <outilex/fsa-determinize.h>
#include <outilex/fsa-prune.h>
#include <outilex/fsa-topological-sort.h>

void sentence_fsa::determinize() {
  fsa_determinize(A);
}

void sentence_fsa::prune() {
  fsa_prune(A);
}

void sentence_fsa::topological_sort() {
  fsa_topological_sort(A);
}


void sentence_fsa::strip_lexic(mutable_lexic & mlex) {

  for (int q = 0; q < size(); ++q) {

    for (intern_trans_iterator it = A.trans_begin(q), end = A.trans_end(q);
         it != end; ++it) {

      intern_transition & tr = *it;
      tr.label() = mlex.add(lexic[tr.label()]);
    }
  }
  set_lexic(mlex);
}


