#ifndef OUTILEX_OTEXTFSA_LEXIC_BUFFERED_
#define OUTILEX_OTEXTFSA_LEXIC_BUFFERED_

#include <vector>
#include <outilex/text_fsa.h>
#include <outilex/sentence_fsa.h>

class otext_fsa_lexic_buf : public otext_fsa {

public:

  otext_fsa_lexic_buf(otext_fsa & out, int maxsize = std::numeric_limits<int>::max())
    : otext(out), bloc(), lexic(), lexic_size(maxsize) {}

  ~otext_fsa_lexic_buf() { close(); }

  void write(const sentence_fsa & fsa) {

    bloc.push_back(fsa);
    bloc.back().strip_lexic(lexic);
    bloc.back().set_lexic(LEXIC());

    if (lexic.size() > lexic_size) {
      flush();
    }
  }

  void flush() {
    //std::cerr << "flush: lexic size = " << lexic.size() << " bloc size = "<< bloc.size() << "\n";
    LEXIC l(lexic);
    for (int i = 0; i < bloc.size(); ++i) {
      bloc[i].set_lexic(l);
      otext << bloc[i];
    }
    bloc.clear();
    lexic.clear();
  }

  void close() { flush(); otext.close(); }

  bool ok() { return otext.ok(); }

public:
  otext_fsa & otext;
  std::vector<sentence_fsa> bloc;
  mutable_lexic lexic;
  int lexic_size;
};

#endif

