#ifndef OUTILEX_MEM_TEXT_FSA_H_
#define OUTILEX_MEM_TEXT_FSA_H_

#include <deque>
#include <outilex/text_fsa.h>


class mem_iotext_fsa : public itext_fsa, public otext_fsa {

  mem_iotext_fsa() : tab() {}

  // otext_fsa API
  void write(const sentence_fsa & fsa) { tab.push_back(fsa); }

  // itext_fsa API
  bool read_next(sentence_fsa & fsa) {
    if (tab.empty()) { return false; }
    fsa.swap(tab.front());
    tab.pop_front();
    return true;
  }

  // lecture unidirectionnelle uniquement
  int tell() const { return 0; }
  void seek(int pos) { throw std::logic_error("iotext_fsa: seek unavailable"); }
  void rewind() { throw std::logic_error("iotext_fsa: rewind unavailable"); }

  // common API
#warning "io_text_fsa: semantic of size()?"
  int size() const { return tab.size(); }
  bool ok() const { return ! tab.empty(); }

public:
  std::deque<sentence_fsa> & tab;
};

#endif
