#ifndef _BIN_TEXT_FSA_H_
#define _BIN_TEXT_FSA_H_

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/fstream.hpp>
#include <outilex/lexic.h>

#include <outilex/text_fsa.h>

class ling_def;
class sentence_fsa;

class bin_itext_fsa : public itext_fsa {

  boost::filesystem::path path;
  boost::filesystem::ifstream stream;
  ling_def * lingdef;
  LEXIC lexic;

  int size_;
  int pos_;

public:

  bin_itext_fsa(const boost::filesystem::path & path, ling_def * ldef)
    : path(), stream(), lingdef(ldef), size_(-1), pos_(-1) { open(path); }

  void open(const boost::filesystem::path & path);
  void close();

  inline int size() const { return size_; }

  bool read_next(sentence_fsa & fsa);

  int tell() const { return pos_; }
  void seek(int pos);
  void rewind();

  bool ok() const { return (stream && pos_ != -1); }

  // void on_lexic_change(...function...);
};

inline bin_itext_fsa & operator>>(bin_itext_fsa & itext, sentence_fsa & fsa) {
  itext.read_next(fsa); return itext;
}

class bin_otext_fsa : public otext_fsa {

  boost::filesystem::ofstream stream;
  LEXIC lexic;

public:

  bin_otext_fsa(const boost::filesystem::path & path, int size);

  ~bin_otext_fsa() { close(); }

  void open(const boost::filesystem::path & path, int size);
  void close();

  void write(const sentence_fsa & fsa);

  bool ok() const { return stream; }
};

inline bin_otext_fsa & operator<<(bin_otext_fsa & text, const sentence_fsa & fsa) {
  text.write(fsa); return text;
}

#endif

